/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util.filters;

import java.io.File;
import java.io.FilenameFilter;

/**
 * 文件名后缀过滤器，要求结尾的
 *
 * @version v1.0.0 @author zouzhigang 2017-4-11 新建与整理
 */
public class FileNameEndsWithFilter implements FilenameFilter
{
    private String suffix;
    
    public FileNameEndsWithFilter(String suffix)
    {
        this.suffix = suffix;
    }
    
    public FileNameEndsWithFilter param(String suffix)
    {
        this.suffix = suffix;
        return this;
    }
    
    @Override
    public boolean accept(File dir, String name)
    {
        return name.endsWith(suffix);
    }
}
