/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 非重复集合类静态扩展类
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Setx")
public class Setx extends Collectionx
{
    // Query Operations 查询操作

    public static int size(Set<?> set)
    {
        return (set == null)?0:set.size();
    }

    public static boolean isEmpty(Set<?> set)
    {
        return (set == null)?true:set.isEmpty();
    }

    public static boolean contains(Set<?> set, Object o)
    {
        return (set == null)?false:set.contains(o);
    }

    public static <E> Iterator<E> iterator(Set<E> set)
    {
        return set.iterator();
    }

    public static Object[] toArray(Set<?> set)
    {
        return set.toArray();
    }

    public static <T> T[] toArray(Set<T> set, T[] a)
    {
        return set.toArray(a);
    }

    // Modification Operations 修改操作

    public static <E> boolean add(Set<E> set, E e)
    {
        return (set == null)?false:set.add(e);
    }

    public static boolean remove(Set<?> set, Object o)
    {
        return (set == null)?false:set.remove(o);
    }

    // Bulk Operations 批量操作

    public static boolean containsAll(Set<?> set, Collection<?> c)
    {
        return (set == null)?false:set.containsAll(c);
    }
   
    public static <E> boolean addAll(Set<E> set, Collection<? extends E> c)
    {
        return (set == null)?false:set.addAll(c);
    }

    public static boolean retainAll(Set<?> set, Collection<?> c)
    {
        return (set == null)?false:set.retainAll(c);
    }

    public static boolean removeAll(Set<?> set, Collection<?> c)
    {
        return (set == null)?false:set.removeAll(c);
    }

    public static void clear(Set<?> set)
    {
        if (set != null)set.clear();
    }

    // Comparison and hashing 

    public static boolean equals(Set<?> set, Object o)
    {
        return (set == null)?(o == null):set.equals(o);
    }

    public static int hashCode(Set<?> set)
    {
        return (set == null)?0:set.hashCode();
    }
}
