/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.logging;

import java.util.List;

/**
 * 日志服务
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
public interface LogService extends LogConstants
{
    /**
     * 获取日志记录器列表，通过日志事件
     * 
     * @param log   日志对象
     * @param level 日志级别
     * @return      日志记录器列表
     */
    public List<Logger> getLoggerList(Log log, int level);
    
    /**
     * 判断日志记录器是否开启
     * 
     * @param log   日志对象
     * @param level 日志级别
     * @return      日志记录器是否开启=true表示已开启,=false表示未开启
     */
    public boolean isLoggerEnabled(Log log, int level);
}
