/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.logging;

import java.util.ArrayList;
import java.util.List;

import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.Servicer;
import org.zhiqim.kernel.config.Group;

/**
 * 适配其他日志服务器，调用其他打印日志服务日志
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
public class LogServerAdapter extends Servicer implements LogService
{
    private List<Logger> loggerList = new ArrayList<Logger>(0);
    
    @Override
    public boolean create() throws Exception
    {
        Group group = Global.getGroup(id);
        
        //先检查日志工厂方法
        String adapter = group.getString("adapter");
        if (adapter == null)
        {
            System.out.println("未配置日志适配器");
            return false;
        }
        
        Object logger = Global.newInstance(adapter);
        if (logger == null || !(logger instanceof LogAdapter) || !(logger instanceof Logger))
        {
            System.out.println("配置的日志适配器无法初始化或未实现LogAdapter或Logger接口");
            return false;
        }
        
        if (!((LogAdapter)logger).adapter())
        {
            System.out.println("配置的日志适配器适配失败");
            return false;
        }
        
        //最后创建一个适配日志输出器
        loggerList.add((Logger)logger);
        LogFactory.updateLogService(this);
        return true;
    }
    
    @Override
    public List<Logger> getLoggerList(Log log, int level)
    {
        return loggerList;
    }

    @Override
    public boolean isLoggerEnabled(Log log, int level)
    {
        return !loggerList.isEmpty() && loggerList.get(0).isLoggerEnabled(log, level);
    }
}
