/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.logging;

import java.io.File;

import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.schedule.ScheduleFactory;
import org.zhiqim.kernel.schedule.Scheduler;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Systems;

/**
 * 缺省配置的LinuxNohup日志分割器
 * 
 * 1.文件路径 ./nohup.out
 * 2.备份目录为当前目录
 * 3.备份文件数为1个
 * 4.保留日志条数为30条
 *
 * @version v1.0.0 @author zouzhigang 2016-2-27 新建与整理
 */
public class LogLinuxNohupCutter extends LogLinuxCutter
{
    private static final Log log = LogFactory.getLog(LogLinuxNohupCutter.class);
    
    @Override
    public boolean create() throws Exception
    {
        if (!Systems.isLinux())
        {//不是Linux直接成功
            return true;
        }
        
        filePath = "./nohup.out";
        File file = new File(filePath);
        if (!Files.isFile(file) || !file.canRead())
        {
            log.error("日志切割器[%s]不存在[./nohup.out]，不处理", id);
            return false;
        }
        
        fileName = file.getName();
        fileDir = Files.toLinuxPath(file.getParentFile().getCanonicalPath());
        fileBakDir = fileDir;
        maxNum = 1;
        keepLogNum = 30;
        schedule = "{name:Day, time:5/29/31, first:false}";
        TaskThreader threader = ScheduleFactory.getTaskThreader(this, schedule);
        
        //建立任务
        scheduler = Global.getService(Scheduler.class);
        if (scheduler == null)
        {
            scheduler = Global.getWithoutNew(Scheduler.class);
            scheduler.create();
            schedulerCreated = true;
        }
        
        taskId = scheduler.addTask(threader);
        log.info("日志切割器[%s][%s]初始化完成!!!", id, filePath);
        return true;
    }

}
