/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.logging;

import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.logging.logger.ConsoleLogger;
import org.zhiqim.kernel.logging.logger.FileLogger;
import org.zhiqim.kernel.util.Systems;

/**
 * 日志配置信息
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
public class LogConfig
{
    private String id;                          //配置编号
    
    private int levelMin;                       //支持的最小级别
    private int levelMax;                       //支持的最大级别
    private String mustName;                    //指定日志名
    private Class<?> mustClass;                 //指定类名
    
    private boolean consoleOut;                //是否支持控制台输出
    private String consolePattern;              //控制台日志模式
    private ConsoleLogger consoleLogger;        //控制台日志类
    
    private boolean fileOut;                   //支持输出日志模式
    private String filePath;                    //文件日志打印路径
    private String filePattern;                 //文件日志打印模式
    private String fileEncoding;                //文件编码
    private int fileMaxNum;                     //文件最多保存个数，由日志类本身去控制FileDailyLogger是天数,FileSizeLogger是个数
    private int fileMaxSize;                    //文件允许的大小
    private FileLogger fileLogger;              //文件日志类
    
    public String toString()
    {
        return Global.getGroup(id).toString();
    }

    /***********************************************************************************/
    //id & level & must 三项 getter / setter
    /***********************************************************************************/
    
    public String getId()
    {
        return id;
    }

    public void setId(String id)
    {
        this.id = id;
    }

    public int getLevelMin()
    {
        return levelMin;
    }

    public void setLevelMin(int levelMin)
    {
        this.levelMin = levelMin;
    }

    public int getLevelMax()
    {
        return levelMax;
    }

    public void setLevelMax(int levelMax)
    {
        this.levelMax = levelMax;
    }

    public String getMustName()
    {
        return mustName;
    }

    public void setMustName(String mustName)
    {
        this.mustName = mustName;
    }

    public Class<?> getMustClass()
    {
        return mustClass;
    }

    public void setMustClass(Class<?> mustClass)
    {
        this.mustClass = mustClass;
    }
    
    /***********************************************************************************/
    //控制台配置 getter & setter
    /***********************************************************************************/

    public boolean isConsoleOut()
    {
        return consoleOut;
    }

    public void setConsoleOut(boolean consoleOut)
    {
        this.consoleOut = consoleOut;
    }
    
    public String getConsolePattern()
    {
        return consolePattern;
    }

    public void setConsolePattern(String consolePattern)
    {
        this.consolePattern = consolePattern;
    }

    public ConsoleLogger getConsoleLogger()
    {
        return consoleLogger;
    }

    public void setConsoleLogger(ConsoleLogger consoleLogger)
    {
        this.consoleLogger = consoleLogger;
    }

    /***********************************************************************************/
    //文件配置 getter & setter
    /***********************************************************************************/
    
    public boolean isFileOut()
    {
        return fileOut;
    }

    public void setFileOut(boolean fileOut)
    {
        this.fileOut = fileOut;
    }

    public String getFilePath()
    {
        return filePath;
    }

    public void setFilePath(String filePath)
    {
        this.filePath = Systems.replacePropertyPath(filePath);
    }

    public String getFilePattern()
    {
        return filePattern;
    }

    public void setFilePattern(String filePattern)
    {
        this.filePattern = filePattern;
    }

    public int getFileMaxNum()
    {
        return fileMaxNum;
    }

    public void setFileMaxNum(int fileMaxNum)
    {
        this.fileMaxNum = fileMaxNum;
    }
    
    public int getFileMaxSize()
    {
        return fileMaxSize;
    }

    public void setFileMaxSize(int fileMaxSize)
    {
        this.fileMaxSize = fileMaxSize;
    }

    public String getFileEncoding()
    {
        return fileEncoding;
    }

    public void setFileEncoding(String fileEncoding)
    {
        this.fileEncoding = fileEncoding;
    }

    public FileLogger getFileLogger()
    {
        return fileLogger;
    }

    public void setFileLogger(FileLogger fileLogger)
    {
        this.fileLogger = fileLogger;
    }
}
