/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.json.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.zhiqim.kernel.json.Json;
import org.zhiqim.kernel.json.JsonParser;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Validates;

/**
 * Map解析器
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class MapParser implements JsonParser
{
    private Json jsonMain;
    
    @Override
    public JsonParser set(Json jsonMain)
    {
        this.jsonMain = jsonMain;
        return this;
    }
    
    @Override
    public String toString(Object obj)
    {
        Map<?, ?> map = (Map<?, ?>)obj;
        if (map.isEmpty())
            return "{}";
        
        StringBuilder strb = new StringBuilder("{");
        for (Entry<?, ?> entry : map.entrySet())
        {
            String key = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            strb.append("\"").append(key).append("\":").append(jsonMain.toString(value)).append(",");
        }
        
        strb.setLength(strb.length() - 1);
        strb.append("}");
        return strb.toString();
    }

    @Override
    public Object toObject(String json, Class<?> cls)
    {
        Map<String, Object> map = Classes.newMap(cls);
        if (map == null)
        {//不支持的类型
            return null;
        }
        
        List<String> fieldList = toFieldList(json);
        for (String s : fieldList)
        {
            int ind = s.indexOf(":");
            String key = Jsons.removeStartEndQuotation(s.substring(0, ind));
            String value = s.substring(ind+1);
            
            if ("null".equals(value))
            {//对null进行判断
                map.put(key, null);
                continue;
            }
            
            if (Jsons.isStartEndQuotation(value))
            {//是字符串
                map.put(key, Jsons.removeEscapeChar(Jsons.removeStartEndQuotation(value)));
                continue;
            }
            
            //基本类型、数组或对象
            if (Validates.isInteger(value))//数值统一转为long，以便强制转化
                map.put(key, Long.parseLong(value));
            else if (Validates.isFloat(value))//浮点统一转为double，以便强制转化
                map.put(key, Double.parseDouble(value));
            else if ("true".equalsIgnoreCase(value))
                map.put(key, true);
            else if ("false".equalsIgnoreCase(value))
                map.put(key, false);
            else
                map.put(key, value);
        }
        
        return map;
    }
    
    /** 折分成字符串数组 */
    public static List<String> toFieldList(String json)
    {
        if (Validates.isEmptyBlank(json))
            return new ArrayList<String>();
        
        if (!json.startsWith("{") || !json.endsWith("}"))
            return new ArrayList<String>();
        
        //去除{}
        json = json.substring(1, json.length()-1);
        return Jsons.getFieldList(json);
    }
}
