/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.json.parser;

import java.util.Collection;
import java.util.List;

import org.zhiqim.kernel.json.Json;
import org.zhiqim.kernel.json.JsonParser;
import org.zhiqim.kernel.util.Classes;

/**
 * 列表解析器
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class ListParser implements JsonParser
{
    private Json jsonMain;
    
    @Override
    public JsonParser set(Json jsonMain)
    {
        this.jsonMain = jsonMain;
        return this;
    }

    @Override
    public String toString(Object obj)
    {
        Collection<?> list = (Collection<?>)obj;
        if (list.isEmpty())
            return "[]";
        
        StringBuilder strb = new StringBuilder("[");
        for (Object o : list)
        {
            strb.append(jsonMain.toString(o)).append(",");
        }
        strb.setLength(strb.length()-1);
        strb.append("]");
        return strb.toString();
    }

    @Override
    public Object toObject(String json, Class<?> cls)
    {
        Collection<Object> list = Classes.newList(cls);
        if (list == null)
        {//不支持的集合类型
            return null;
        }
        
        List<String> jList = ArrayParser.toFieldList(json);
        for (String str : jList)
        {
            list.add(str);
        }
        
        return list;
    }

}
