/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.json.parser;

import org.zhiqim.kernel.json.Json;
import org.zhiqim.kernel.json.JsonParser;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;

/**
 * 基本类型适配器，8种基本类型&字符串
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class BaseParser implements JsonParser
{
    private static final long MAX_JS_LONG_VALUE = (long) Math.pow(2, 53);//2^53//9007199254740992
    
    private Json jsonMain;
    
    @Override
    public JsonParser set(Json jsonMain)
    {
        this.jsonMain = jsonMain;
        return this;
    }
    
    @Override
    public String toString(Object obj)
    {
        if (jsonMain.isJsLong() && obj instanceof Long)
        {//对long型进行判断，超过JS支持的最大值时行字符串处理，防止JS数值不准
            long l = (Long)obj;
            if (l > MAX_JS_LONG_VALUE)
                return new StringBuilder("\"").append(l).append("\"").toString();
        }
        else if (obj instanceof String)
        {//要对引号进行增加转义
            String str = Jsons.addEscapeChar((String)obj, '\"');
            return new StringBuilder("\"").append(str).append("\"").toString();
        }

        return String.valueOf(obj);
    }
    
    @Override
    public Object toObject(String json, Class<?> cls)
    {
        //去掉前后可能的引号
        json = Jsons.removeStartEndQuotation(json);
        
        if (cls == boolean.class || cls == Boolean.class)
            return Boolean.parseBoolean(json);
        else if (cls == byte.class || cls == Byte.class)
            return Byte.parseByte(json);
        else if (cls == char.class || cls == Character.class)
            return json.charAt(0);
        else if (cls == short.class || cls == Short.class)
            return Short.parseShort(json);
        else if (cls == int.class || cls == Integer.class)
            return Ints.toInt(json);
        else if (cls == long.class || cls == Long.class)
            return Longs.toLong(json);
        else if (cls == float.class|| cls == Float.class)
            return Float.parseFloat(json);
        else if (cls == double.class || cls == Double.class)
            return Double.parseDouble(json);
        else if (cls == String.class)
            return Jsons.removeEscapeChar(json);//字符串要求删除转义
        else
            return null;
    }
}
