/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.extend;

/**
 * 字符串作KEY的V定义，[key, value]成对出现
 *
 * @version v1.0.0 @author zouzhigang 2018-7-20 新建与整理
 */
public final class SV<V>
{
    private String key;
    private V value;
    
    public SV(String key, V value)
    {
        this.key = key;
        this.value = value;
    }
    
    public String key()
    {
        return key;
    }
    
    public V value()
    {
        return value;
    }

    public void key(String key)
    {
        this.key = key;
    }

    public void value(V value)
    {
        this.value = value;
    }

    public String toString()
    {
        return new StringBuilder("SV:[")
            .append("key=").append(key).append(";")
            .append("value=").append(value).append("]")
            .toString();
    }
}
