/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.control;

/**
 * 线程锁（运用对象中wait和notify方法转化为线程的锁定状态<br><br>
 * locked     判断正被处理的线程是否锁定，锁定即空闲<br>
 * 
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 * @version v1.5.0 @author zouzhigang 2018-11-20 删除实现Serializable，没什么意义
 */
public final class ThreadLock
{
    private boolean locked;
    
    /** 当前对象所在的线程是否锁定中 */
    public boolean isLocked()
    {
        return locked;
    }
    
    /** 锁定当前线程，直到收到其他线程发送通知为止 */
    public void lock()
    {
        lock(0);
    }
    
    /**
     * 锁定当前线程，直到收到其他线程发送通知或等待时间结束自动唤醒
     * 
     * @param timeout 等待时间，单位毫秒
     */
    public synchronized void lock(long timeout)
    {
        try
        {
            locked = true;
            wait(timeout);
            locked = false;//正常notify
        }
        catch (InterruptedException ex)
        {
            locked = false;//线程interrupt
        }
    }

    /** 解除线程锁定，通知正在等待的线程结束阻塞线程 */
    public synchronized void unlock()
    {
        notify();
    }
}