/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙微内核（zhiqim_kernel）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.control;

/**
 * 可配置接口定义，用于跨框架之间相互配置参数<br><br>
 * 举例：<br>
 * 1、ZhiqimHttpd的HttpRequest,HttpContext实现Configurable，并实现配置<br>
 * 2、ZhiqimORM的ORM类从request/context中读取配置的值<br>
 * 
 *
 * @version v1.0.0 @author zouzhigang 2018-11-29 新建与整理
 */
public interface Configurable
{
    /** 读取配置值 */
    public String getConfiguration();
}
