/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.constants;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * Zhiqim常量定义
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27  新建与整理
 * @version v1.3.0 @author zouzhigang 2016-2-27  修改为1.3.0版本
 * @version v1.4.0 @author zouzhigang 2017-11-20 修改为1.4.0版本
 * @version v1.5.0 @author zouzhigang 2018-8-15  修改为1.5.0版本
 */
@AnAlias("ZhiqimConstants")
public interface ZhiqimConstants extends SignConstants
{
    public String Z_NAME                       = "zhiqim";
    public String Z_NAME_CN                    = "知启蒙";
    public String Z_VERSION                    = "V1.5.0";
    
    /******************************************************************/
    //Zhiqim 工程结构常量
    /******************************************************************/
    
    public String Z_LIB_FOLDER                 = "./lib";
    public String Z_LIB_ZHIQIM_JAR             = "./lib/zhiqim.jar";
    public String Z_CONF_FOLDER                = "./conf";
    public String Z_CONF_ZHIQIM_XML            = "./conf/zhiqim.xml";
    public String Z_CONF_ZHIQIM_INI            = "./conf/zhiqim.ini";
    
    /******************************************************************/
    //Zhiqim 默认配置常量
    /******************************************************************/
    
    public String Z_BOOT                       = "boot";
    public String Z_CONFIG                     = "config";
    public String Z_SERVICE                    = "service";
    
    public String Z_ITEM_NAME                  = _NAME_;
    public String Z_ITEM_VERSION               = _VERSION_;
    public String Z_ITEM_PORT                  = "port";
    public String Z_ITEM_LIBEXT                = "libext";
    public String Z_ITEM_INCLUDE               = "include";
    public String Z_ITEM_EXCLUDE               = "exclude";
    
    /******************************************************************/
    //Zhiqim 支持的命令常量
    /******************************************************************/
    
    public String Z_START_A                    = "-s";
    public String Z_CLOSE_A                    = "-c";
    public String Z_INFO_A                     = "-i";
    public String Z_TEST_A                     = "-t";
    public String Z_RELOAD_A                   = "-r";
    public String Z_HELP_A                     = "-h";
    public String Z_QUESTION_A                 = "-?";
    
    public String Z_START_C                    = "start";
    public String Z_CLOSE_C                    = "close";
    public String Z_INFO_C                     = "info";
    public String Z_TEST_C                     = "test";
    public String Z_RELOAD_C                   = "reload";
    public String Z_HELP_C                     = "help";
    public String Z_QUESTION_C                 = "?";
    
    /******************************************************************/
    //Zhiqim 配置常量
    /******************************************************************/
    
    public String Z_CONFIG_DTD_PATH            = "/org/zhiqim/kernel/config/zhiqim_config_1_5_0.dtd";
    
    public String Z_CONFIG_DTD_PUBLIC_ID       = "-//ZHIQIM //DTD Zhiqim-Config Configuration 1.5.0//EN";
    public String Z_CONFIG_DTD_URL             = "http://zhiqim.org/xmldtds/zhiqim_config_1_5_0.dtd";
    public String Z_CONFIG_XML_DOCTYPE         = "<!DOCTYPE ZHIQIM-CONFIG PUBLIC \""+ Z_CONFIG_DTD_PUBLIC_ID +"\" \""+ Z_CONFIG_DTD_URL +"\">";

    public String Z_CONFIG_XML_HEAD            = "<zhiqim-config>";
    public String Z_CONFIG_XML_TAIL            = "</zhiqim-config>";
    
    public String GROUP                        = "group";
    public String ID                           = _ID_;
    public String DESC                         = "desc";
    
    public String ITEM                         = "item";
    public String KEY                          = _KEY_;
    public String VALUE                        = _VALUE_;
    public String TYPE                         = _TYPE_;
}
