/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.constants;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 正则表达式常量定义
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
@AnAlias("RegexpConstants")
public interface RegexpConstants
{
    /** 需要转义的字符 */
    public String ESCAPE                       = "*.?+$^[](){}|\\/";
    
    /*********************************************************************************************************************************************/
    //数字相关
    /*********************************************************************************************************************************************/
    
    public String NUMERIC                      = "^\\d+$";//数字，至少1位
    public String NUMERIC_N                    = "^\\d{n}$";//N位数字
    public String NUMERIC_TN                   = "^\\d{n,}$";//至少N位数字
    public String NUMERIC_N_M                  = "^\\d{n,m}$";//N-M位数字
    
    public String INTEGER                      = "^(0|[\\+\\-]?[1-9]\\d*)$";//整数，支持正负数
    public String INTEGER_P                    = "^[1-9]\\d*$";//正整数，第一个数字是1-9
    public String INTEGER_N                    = "^\\-[1-9]\\d*$";//负整数，负号之后第一个数字是1-9
    public String INTEGER_N_N                  = "^(0|[1-9]\\d*)$";//非负整数，0或者正整数
    public String INTEGER_N_P                  = "^(0|\\-[1-9]\\d*)$";//非正整数，0或者负整数
    
    public String FLOAT_INT                    = "^(0|[1-9]\\d*)(\\.\\d+)?$";//浮点值，支持多位小数
    public String FLOAT                        = "^(0|[\\+\\-]?[1-9]\\d*)(\\.\\d+)?$";//浮点值，支持多位小数点，支持正负数
    
    public String AMOUNT_INT_2R                = "^(0|[1-9]\\d*)(\\.\\d{1,2})?$";//标准元金额，支持0-2位小数
    public String AMOUNT_INT_2R_FIXED          = "^(0|[1-9]\\d*)(\\.\\d{2})$";//固定元金额，两位小数
    public String AMOUNT_2R                    = "^(0|[\\+\\-]?[1-9]\\d*)(\\.\\d{1,2})?$";//标准元金额，支持0-2位小数，支持正负数
    public String AMOUNT_2R_FIXED              = "^(0|[\\+\\-]?[1-9]\\d*)(\\.\\d{2})$";//固定元金额，两位小数，支持正负数
    
    /*********************************************************************************************************************************************/
    //字符相关
    /*********************************************************************************************************************************************/
    
    public String ALPHABAT                     = "^[A-Za-z]+$";//字母
    public String ALPHABAT_UPPER               = "^[A-Z]+$";//大写字母
    public String ALPHABAT_LOWER               = "^[a-z]+$";//小写字母

    public String ALPHA_LOWER_NUMERIC          = "^[a-z0-9]+$";//小写字母或数字
    public String ALPHA_UPPER_NUMERIC          = "^[A-Z0-9]+$";//大写字母或数字
    
    public String ALPHA_NUMERIC                = "^[A-Za-z0-9]+$";//大写小字母和数字
    public String ALPHA_NUMERIC_N_M            = "^[A-Za-z0-9]{n,m}$";//大写小字母和数字
    public String ALPHA_NUMERIC_PA             = "^[A-Za-z][A-Za-z0-9]*$";//大写小字母和数字，字母开头
    public String ALPHA_NUMERIC_PA_N_M         = "^[A-Za-z][A-Za-z0-9]{n,m}$";//大写小字母和数字，字母开头

    public String ALPHA_NUMERIC_UL             = "^[A-Za-z0-9_]+$";//字母，数字或下划线
    public String ALPHA_NUMERIC_UL_PA          = "^[A-Za-z_][A-Za-z0-9_]*$";//大写小字母和数字，字母或下划线开头，java变量和方法命名
    public String ALPHA_NUMERIC_UL_DL_PA       = "^[A-Za-z_\\$][A-Za-z0-9_\\$]*$";//大写小字母和数字，字母或下划线或$开头，js变量和方法命名
    
    public String ALPHA_NUMERIC_DOT            = "^[A-Za-z0-9\\.]+$";//字母，数字或点号，如版本号V1.0.0
    public String ALPHA_NUMERIC_URL            = "^[A-Za-z0-9\\.\\-_~]+$";//字母，数字或.-_~（URL支持的四个字符）
    
    public String ALPHABAT_DOUBLE              = "^[^x00-xff]+$";//双字节
    public String CHINESE                      = "^[\u4e00-\u9fa5]+$";//中文
    public String CHINESE_ALPHA_NUMERIC        = "^[\u4e00-\u9fa5A-Za-z0-9]+$";//中文大小写字母和数字
    
    public String HEX                          = "^[A-Fa-f0-9]+$";//十六进制字符
    public String MD5                          = "^[A-Fa-f0-9]{32}$";//32位十六进制字符
    
    //账号和密码支持的特殊符号共10个[._-`~!@#$%]，账号要求2-16位字母数字或中文开头，密码要求6-16位的大小写字母数字和特殊符号满足四选三
    public String USER_CODE                    = "^[a-zA-Z0-9\\u4e00-\\u9fa5][._\\-`~!@#$%a-zA-Z0-9\\u4e00-\\u9fa5]{1,15}$";
    public String USER_PASS                    = "^(?:(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9])|(?=.*[A-Z])(?=.*[a-z])(?=.*[._\\-`~!@#$%])|(?=.*[A-Z])(?=.*[0-9])(?=.*[._\\-`~!@#$%])|(?=.*[a-z])(?=.*[0-9])(?=.*[._\\-`~!@#$%])).{6,16}$";
    
    /*********************************************************************************************************************************************/
    //需求表达式
    /*********************************************************************************************************************************************/
    
    public String MOBILE                       = "^((\\+86)|(86)|)?(13[0-9]|14[5|7|9]|15[0|1|2|3|5|6|7|8|9]|17[0|1|3|5|6|7|8]|18[0-9])\\d{8}$";
    public String MOBILE_11                    = "^(13[0-9]|14[5|7|9]|15[0|1|2|3|5|6|7|8|9]|17[0|1|3|5|6|7|8]|18[0-9])\\d{8}$";
    public String IP                           = "^((?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])\\.){3}(?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])$";
    public String MAC                          = "^[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}$";
    public String QQ                           = "^[1-9]\\d{4,10}$";
    public String POSTAL_CODE                  = "^[1-9]\\d{5}$";
    public String EMAIL                        = "^([\\w-_]+(?:\\.[\\w-_]+)*)@((?:[a-z0-9]+(?:-[a-zA-Z0-9]+)*)+\\.[a-z]{2,6})$";
    public String FILE_NAME                    = "(?!((^(?i)con$)|(^(?i)con\\..*)|(^(?i)prn$)|(^(?i)prn\\..*)|(^(?i)aux$)|(^(?i)aux\\..)|(^(?i)nul$)|(^(?i)nul\\..*)|(^(?i)com[0-9]$)|(^(?i)com[0-9]\\..*)|(^(?i)lpt[0-9]$)|(^(?i)lpt[0-9]\\..*)|(^\\s+)|(.*\\s$)|(^\\.$)))(^[^\\\\/\\:\\*\\?\\\"\\<\\>\\|]{1,255}$)";
    
    public String DATE                         = "^(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)$";
    public String TIME                         = "^([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9])$";
    public String DATE_TIME                    = "^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))\\s(([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9]))$";
    public String IDCARD                       = "^(\\d{6})((((19|20)[0-9]{2})(((0[13578]|1[02])(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))(\\d{3}[0-9xX*])$";
    
    /*********************************************************************************************************************************************/
    //表情符号
    /*********************************************************************************************************************************************/
    
    public String SYMBOLS_UNICODE              = "[\u2300-\u23FF]|"+//杂项工业符号 (Miscellaneous Technical)
                                                                "[\u2600-\u27FF]|"+//杂项符号 (Miscellaneous Symbols)  
                                                                "[\u2B00-\u2BFF]|"+//杂项符号和箭头 (Miscellaneous Symbols and Arrows)  
                                                                "[\uFE00-\uFE0F]";//变量选择符 (Variation Selector)
   
    public String SYMBOLS_EMOJI_IOS            = "[\uD83C\uDC00-\uD83C\uDFFF]|" +
                                                                "[\uD83D\uDC00-\uD83D\uDFFF]|" +
                                                                "[\uD83E\uDC00-\uD83E\uDFFF]|" +
                                                                "[\uD800\uDC00-\uDBFF\uDFFF]";//全部的D800-DBFF,DC00-DFFF
    
    public String SYMBOLS_ALL                  = SYMBOLS_UNICODE + "|" + SYMBOLS_EMOJI_IOS;
    
    /*********************************************************************************************************************************************/
    //方法相关
    /*********************************************************************************************************************************************/
    
    public String IS_REGEXP                    = "isRegexp";
    
    public String IS_NUMERIC                   = "isNumeric";
    public String IS_NUMERIC_LEN               = "isNumericLen";
    public String IS_INTEGER                   = "isInteger";
    public String IS_INTEGER_VALUE             = "isIntegerValue";
    
    public String IS_ALPHA_NUMERIC             = "isAlphaNumeric";
    public String IS_ALPHA_NUMERIC_LEN         = "isAlphaNumericLen";
    public String IS_ALPHA_NUMERIC_PA_LEN      = "isAlphaNumericPALen";
    public String IS_ALPHA_NUMERIC_UL_LEN      = "isAlphaNumericULLen";
    public String IS_ALPHA_NUMERIC_UL_PA_LEN   = "isAlphaNumericULPALen";
    
    public String IS_ALPHA_NUMERIC_DOT_LEN     = "isAlphaNumericDotLen";
    public String IS_ALPHA_NUMERIC_URL_LEN     = "isAlphaNumericUrlLen";
    
    public String IS_FLOAT                     = "isFloat";
    public String IS_AMOUNT_2R                 = "isAmount2R";
    public String IS_EMAIL                     = "isEmail";
    public String IS_POSTAL_CODE               = "isPostalCode";
    public String IS_IP                        = "isIP";
    public String IS_MAC                       = "isMacAddress";
    
    public String IS_MOBILE                    = "isMsisdn";
    public String IS_MOBILE11                  = "isMsisdn11";
    public String IS_DATE                      = "isDate";
    public String IS_TIME                      = "isTime";
    public String IS_DATE_TIME                 = "isDateTime";
    public String IS_IDCARD                    = "isIdcard";
    public String IS_USER_CODE                 = "isUserCode";
    public String IS_USER_PASS                 = "isUserPass";
    
    //非正则表达式
    public String IS_EMPTY                     = "isEmpty";
    public String IS_NOT_EMPTY                 = "isNotEmpty";
    public String IS_EQUAL                     = "isEqual";
    public String IS_SCOPE                     = "isScope";

    public String IS_SELECT                    = "isSelect";
    public String IS_CHECKED                   = "isChecked";
    
    public String IS_LEN                       = "isLen";
    public String IS_BYTE_LEN                  = "isByteLen";
    public String IS_LESS_THEN                 = "isLessThen";
    public String IS_LESS_THEN_VALUE           = "isLessThenValue";
    public String IS_LESS_EQUAL_THEN           = "isLessEqualThen";
    public String IS_LESS_EQUAL_THEN_VALUE     = "isLessEqualThenValue";
    public String IS_GREATER_THEN              = "isGreaterThen";
    public String IS_GREATER_THEN_VALUE        = "isGreaterThenValue";
    public String IS_GREATER_EQUAL_THEN        = "isGreaterEqualThen";
    public String IS_GREATER_EQUAL_THEN_VALUE  = "isGreaterEqualThenValue";
}
