/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.constants;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * HTML常量定义
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
@AnAlias("HtmlConstants")
public interface HtmlConstants extends SignConstants
{
    /*************************************************************/
    //Html相关
    /*************************************************************/
    
    public String _HTML_5_TYPE_        = "<!DOCTYPE html>";
    
    public String _HTML                = "<html>";
    public String  HTML_               = "</html>";
    public String _HEAD                = "<head>";
    public String  HEAD_               = "</head>";
    public String _TITLE               = "<title>";
    public String  TITLE_              = "</title>";
    public String _SCRIPT              = "<script>";
    public String _SCRIPT_PRE          = "<script";
    public String _SCRIPT_BR           = "<script>\r\n";
    public String  SCRIPT_             = "</script>";
    public String _STYLE               = "<style>";
    public String _STYLE_BR            = "<style>\r\n";
    public String  STYLE_              = "</style>";
    
    public String _BODY                = "<body>";
    public String  BODY_               = "</body>";
    
    public String _TABLE               = "<table id=\"%id\" width=\"%w\" align=\"%a\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"%b\" class=\"%c\" sytle=\"%s\">";
    public String  TABLE_              = "</table>";
    public String _TR                  = "<tr>";
    public String  TR_                 = "</tr>";
    public String _TD                  = "<td id=\"%id\" width=\"%w\" align=\"%a\" class=\"%c\" sytle=\"%s\">";
    public String  TD_                 = "</td>";
    
    public String _DIV                 = "<div id=\"%id\" class=\"%c\" sytle=\"%s\">";
    public String  DIV_                = "</div>";
    
    /*************************************************************/
    //Script相关
    /*************************************************************/

    public String SCRIPT_HEAD_VALIDATE = "function validateForm(form)\r\n{\r\n";
    public String SCRIPT_TAIL_VALIDATE = _FOUR_ + "return true;\r\n}\r\n\r\n";
    
    public String SCRIPT_HEAD_SUBMIT   = "function submitForm(form)\r\n{\r\n";
    public String SCRIPT_TAIL_SUBMIT   = "}\r\n\r\n";
}
