/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.constants;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 枚举常量定义
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
@AnAlias("EnumConstants")
public interface EnumConstants extends SignConstants
{
    /** 星期，星期天=0或7 */
    public String[] _WEEKS_            = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    
    /** 星期，星期天=0或7 */
    public String[] _WEEKS_ZH_         = {"星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六", "星期日"};
    
    /** 月份，一月=0，十二月=11 */
    public String[] _MONTHS_           = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    
    /** 人民币0-9 */
    public String[] _RMB_NUM_          = {"零", "壹", "贰", "叁", "肆", "伍", "陆", "柒", "捌", "玖"};
    
    /** 人民币单位 */
    public String[] _RMB_UNIT_         = {"圆", "拾", "佰", "仟", "万", "拾", "佰", "仟", "亿", "拾","佰", "仟"};
    
    /** 人民币小数单位 */
    public String[] _RMB_DEC_          = {"角", "分"};
    
    /** 定义12个月份对应的天数 */
    public int[] _DAYS_IN_MONTH_       = {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    
    /** 定义分时天月年秒数 */
    public int[] _SECOND_IN_TIME_      = {3600*24*365, 3600*24*30, 3600*24, 3600, 60};
    
    /** 子网掩码字段允许的值 */
    public String[] _IP_MASK_VALUE_    = {"255", "254", "252", "248", "240", "224", "192", "128", "0"};
    
    /** 33个全子网掩码值 */
    public String[] _IP_MASK_          = {"0.0.0.0",        "128.0.0.0",       "192.0.0.0",        "224.0.0.0",        "240.0.0.0",        "248.0.0.0",        "252.0.0.0",        "254.0.0.0",  
                                           "255.0.0.0",      "255.128.0.0",     "255.192.0.0",      "255.224.0.0",      "255.240.0.0",      "255.248.0.0",      "255.252.0.0",      "255.254.0.0",     
                                           "255.255.0.0",    "255.255.128.0",   "255.255.192.0",    "255.255.224.0",    "255.255.240.0",    "255.255.248.0",    "255.255.252.0",    "255.255.254.0",
                                           "255.255.255.0",  "255.255.255.128", "255.255.255.192",  "255.255.255.224",  "255.255.255.240",  "255.255.255.248",  "255.255.255.252",  "255.255.255.254",
                                           "255.255.255.255"};
    /** 进制数字表 */
    public char[] _BIN_CHAR_           = {'0', '1'};
    public char[] _HEX_CHAR_           = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public char[] _HEX_CHAR_LOW_       = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public byte[] _HEX_BYTE_           = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public byte[] _HEX_BYTE_LOW_       = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    
    /** 图片前缀编码表 */
    public byte[] _PNG_HDR_            = {(byte)0x89, (byte)0x50, (byte)0x4E, (byte)0x47};
    public byte[] _GIF_HDR_            = {(byte)0x47, (byte)0x49, (byte)0x46};//前3字节GIF
    public byte[] _JPG_HDR_            = {(byte)0xFF, (byte)0xD8};
    
    public byte[] _BOM_UTF8_           = {(byte)0xEF, (byte)0xBB, (byte)0xBF};
    public byte[] _BOM_UTF16LE_        = {(byte)0xFF, (byte)0xFE};
    public byte[] _BOM_UTF16BE_        = {(byte)0xFE, (byte)0xFF};
    public byte[] _BOM_UTF32LE_        = {(byte)0xFF, (byte)0xFE, (byte)0x00, (byte)0x00};
    public byte[] _BOM_UTF32BE_        = {(byte)0x00, (byte)0x00, (byte)0xFE, (byte)0xFF};
}
