/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.config;

import org.zhiqim.kernel.constants.SignConstants;

/**
 * 配置项类型
 *
 * @version v1.4.1 @author zouzhigang 2018-4-20 新建与整理
 */
public enum ItemType
{
    /*****************************************************************************/
    //枚举类型定义
    /*****************************************************************************/
    
    /** 公开 */
    PUBLIC,
    
    /** 私有 */
    PRIVATE,
    
    /** 保护 */
    PROTECTED;
    
    /*****************************************************************************/
    //枚举调用方法
    /*****************************************************************************/
    
    public static ItemType toType(String type)
    {
        if (SignConstants._PUBLIC_.equals(type))
            return PUBLIC;
        else if (SignConstants._PRIVATE_.equals(type))
            return PRIVATE;
        else
            return PROTECTED;
    }
    
    public static String toString(ItemType type)
    {
        switch (type)
        {
        case PUBLIC:return SignConstants._PUBLIC_;
        case PRIVATE:return SignConstants._PRIVATE_;
        default:return SignConstants._PROTECTED_;
        }
    }
}
