/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel;

import org.zhiqim.kernel.util.Resources;

/**
 * 国际化定义，用于断言等，其中后面接数字表示参数个数
 *
 * @version v1.0.0 @author zouzhigang 2017-5-31 新建与整理
 */
public class ZhiqimI18n
{
    static
    {//初始化静态属性
        Resources.buildStaticProperties(ZhiqimI18n.class);
    }
    
    
    /*******************************************************************************************/
    //标准参数断言
    /*******************************************************************************************/
    
    /** 参数不能为null */
    public static String parameterCannotBeNull;
    
    /** 参数[%s]不能为null */
    public static String parameterCannotBeNull1;
    
    /** 参数不能为空 */
    public static String parameterCannotBeNullOrEmpty;
    
    /** 参数[%s]不能为空 */
    public static String parameterCannotBeNullOrEmpty1;
    
    /** 参数不能为空白 */
    public static String parameterCannotBeNullOrEmptyBlank;
    
    /** 参数[%s]不能为空白 */
    public static String parameterCannotBeNullOrEmptyBlank1;
    
    /** 参数必须是整型 */
    public static String parameterMustBeInteger;
    
    /** 参数[%s]必须是整型 */
    public static String parameterMustBeInteger1;
    
    /*******************************************************************************************/
    //凡狐内部使用
    /*******************************************************************************************/
    
    /** 不支持添加重复的服务到全局变量中 */
    public static String globalDuplicateServiceNotSupported;
    
    /** 类[%s]不支持空构造函数*/
    public static String classDoesNotSupportNoParameterConstructors;
    
    /** 配置文件[%s]格式不正确 */
    public static String configFileFormatNotCorrect;
    
    /** 索引值必须大于等于零 */
    public static String indexMustBeGreaterThanOrEqualZero;

    
}
