/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_upload_large.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.uploadlarge.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.dbo.Updater;
import org.zhiqim.uploadlarge.dbo.UpllFile;

/**
 * 修改文件属性处理
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class FileUpdateAction implements Action
{
    public void execute(HttpRequest request) throws Exception
    {
        String fileId = request.getParameter("fileId");
        String contentType = request.getParameter("contentType");
        String contentEncoding = request.getParameter("contentEncoding");
        String cacheControl = request.getParameter("cacheControl");
        
        if (Validates.isEmpty(fileId) || Validates.isEmpty(contentType))
        {
            request.returnHistory("ContentType不能为空");
            return;
        }
        
        Updater updater = new Updater();
        updater.addField("contentType", contentType);
        updater.addField("contentEncoding", contentEncoding);
        updater.addField("cacheControl", cacheControl);
        updater.addMust("fileId", fileId);
        
        ORM.table().update(UpllFile.class, updater);
    }
}
