/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_upload_large.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.uploadlarge.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.uploadlarge.dbo.UpllFile;

/**
 * 文件列表
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class FileListAction implements Action
{
    public void execute(HttpRequest request) throws Exception
    {
        request.setResponsePrivateCache();
        int pageNo = request.getParameterInt("page", 1);
        int pageSize = 10;
        
        String fileId = request.getParameter("fileId");
        String fileName = request.getParameter("fileName");
        String fileMd5 = request.getParameter("fileMd5");
        String fileExt = request.getParameter("fileExt");
        String fileBeginDate = request.getParameter("fileBeginDate");
        String fileEndDate = request.getParameter("fileEndDate");
        
        Selector sel = new Selector();
        sel.addMaybe("fileId", fileId);
        sel.addMaybe("fileMd5", fileMd5);
        sel.addMaybeLike("fileName", fileName);
        sel.addMaybe("fileId", fileId);
        sel.addMaybe("fileExt", fileExt);
        if(Validates.isNotEmpty(fileBeginDate))
            sel.addMaybeThenGE("fileTime", fileBeginDate + " 00:00:00");
        if(Validates.isNotEmpty(fileEndDate))
            sel.addMaybeThenLE("fileTime", fileEndDate + " 23:59:59");
        
        sel.addOrderbyDesc("fileTime");
        
        PageResult<UpllFile> result = ORM.table().page(UpllFile.class, pageNo, pageSize,sel);
        result.addConditionMap(request.getParameterMap());
        
        request.setAttribute("result", result);
    }
}
