/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_upload_large.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.uploadlarge.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.uploadlarge.dbo.UpllFile;

/**
 * 删除文件功能
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class FileDeleteAction implements Action
{
    public void execute(HttpRequest request) throws Exception
    {
        String fileId = request.getParameter("fileId");
        if (Validates.isEmpty(fileId))
        {
            request.returnHistory("请选择一个有效的数据");
            return;
        }
        
        UpllFile file = ORM.table().item(UpllFile.class, fileId);
        if (file == null)
        {
            request.returnHistory("请选择一个有效的数据[fileId:"+fileId+"]");
            return;
        }
        
        //当文件MD5只有一条记录时，同时删除文件
        if (ORM.table().count(UpllFile.class, new Selector("fileMd5", file.getFileMd5())) <= 1)
            Files.deleteFile(file.getFilePath());
        
        ORM.table().delete(UpllFile.class, fileId);
    }
}
