/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_upload_large.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.uploadlarge;

import java.io.File;
import java.util.List;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.Tasker;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.uploadlarge.dbo.UpllChunk;

/**
 * 大文件上传数据库任务
 * 1)把前一天的碎片文件删除掉，包括文件
 *
 * @version v1.0.0 @author zouzhigang 2017-7-19 新建与整理
 */
public class UploadLargeTask extends Tasker
{
    private static final Log log = LogFactory.getLog(UploadLargeTask.class);
    
    @Override
    public void execute()
    {
        String datetime = DateTimes.getDateString() + " 00:00:00";
        String chunkTime = DateTimes.getPreviousDateTimeString(datetime, 1);
        
        Selector selector = new Selector().addMustThenL("chunkTime", chunkTime);
        
        try
        {
            List<UpllChunk> list = ORM.table().list(UpllChunk.class, selector);
            int size = list.size();
            int error = 0;
            
            for (UpllChunk chunk : list)
            {
                String filePath = chunk.getFilePath();
                if (Validates.isEmptyBlank(filePath))
                {
                    ORM.table().delete(UpllChunk.class, chunk.getFileMd5(), chunk.getChunkSize());
                    continue;
                }
                    
                File file = new File(filePath);
                if (!file.exists())
                {
                    ORM.table().delete(UpllChunk.class, chunk.getFileMd5(), chunk.getChunkSize());
                    continue;
                }
                
                if (file.delete())
                    ORM.table().delete(UpllChunk.class, chunk.getFileMd5(), chunk.getChunkSize());
                else
                    error++;
            }
            
            log.info("删除[%s]之前的碎片文件完成，总[%s]，失败[%s]...", chunkTime, size, error);
        }
        catch (Exception e)
        {
            log.error("删除[%s]之前的碎片文件时异常", chunkTime, e);
        }
    }
}
