/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.datasource.ZDBClose;
import org.zhiqim.orm.datasource.ZStatement;
import org.zhiqim.orm.executor.BatchExecutor;

public class BatchExecutorMap
implements BatchExecutor {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] execute(ORMServer server, Connection conn, String sql, List<?> paramList, MapSS replaceMap) throws ORMException, SQLException {
        int[] nArray;
        PreparedStatement pstmt = null;
        ArrayList<String> strList = null;
        try {
            sql = Sqls.formatReplaceMap((String)sql, (MapSS)replaceMap);
            ArrayList<String> paramKeyList = new ArrayList<String>();
            int i = 0;
            int start = 0;
            int end = sql.indexOf(35);
            while (end != -1) {
                if (i % 2 != 0) {
                    String paramKey = sql.substring(start + 1, end);
                    paramKeyList.add(paramKey);
                }
                ++i;
                start = end;
                end = sql.indexOf(35, start + 1);
            }
            i = 0;
            while (i < paramKeyList.size()) {
                String paramKey = (String)paramKeyList.get(i);
                sql = sql.replaceAll("#" + paramKey + "#", "?");
                ++i;
            }
            if (server.isUpdateSqlLog()) {
                strList = new ArrayList<String>(paramList.size());
                i = 0;
                while (i < paramList.size()) {
                    String str = sql;
                    strList.add(str);
                    ++i;
                }
            }
            boolean isMapSO = paramList.get(0) instanceof MapSO;
            pstmt = conn.prepareStatement(sql);
            int b = 0;
            while (b < paramList.size()) {
                String str = null;
                if (server.isUpdateSqlLog()) {
                    str = (String)strList.get(b);
                }
                Object v = paramList.get(b);
                Map paramMap = isMapSO ? ((MapSO)v).instance() : (Map)v;
                int i2 = 0;
                while (i2 < paramKeyList.size()) {
                    String paramKey = (String)paramKeyList.get(i2);
                    Object value = paramMap.get(paramKey);
                    if (server.isUpdateSqlLog()) {
                        str = ZStatement.setParameter(server, pstmt, i2 + 1, value, str);
                    } else {
                        ZStatement.setParameter(server, pstmt, i2 + 1, value);
                    }
                    ++i2;
                }
                pstmt.addBatch();
                if (server.isUpdateSqlLog()) {
                    strList.remove(b);
                    strList.add(b, str);
                }
                ++b;
            }
            int[] rets = pstmt.executeBatch();
            if (server.isUpdateSqlLog()) {
                for (String str : strList) {
                    str = str.replaceAll("-%6-%-3%-", "?");
                    uSqlLog.info((Object)str);
                }
            }
            nArray = rets;
        }
        catch (SQLException e) {
            try {
                log.error((Object)"BatchExecutorMap[SQLException][%s][sql=%s]", (Throwable)e, new Object[]{e.getMessage(), sql});
                throw e;
                catch (Exception e2) {
                    log.error((Object)"BatchExecutorMap[Exception][%s]", (Throwable)e2, new Object[]{e2.getMessage()});
                    throw new ORMException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                ZDBClose.close(pstmt);
                throw throwable;
            }
        }
        ZDBClose.close(pstmt);
        return nArray;
    }
}

