/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.dbo;

import java.sql.CallableStatement;
import java.sql.SQLException;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.datasource.ZCall;

public final class CallParam
implements ORMConstants {
    private ORMConstants.CALL_TYPE type;
    private Class<?> clazz;
    private Object value;

    private CallParam(ORMConstants.CALL_TYPE type, Class<?> clazz) {
        this.type = type;
        this.clazz = clazz;
    }

    private CallParam(ORMConstants.CALL_TYPE type, Object value) {
        this.type = type;
        this.value = value;
        this.clazz = value.getClass();
    }

    public ORMConstants.CALL_TYPE type() {
        return this.type;
    }

    public Object value() {
        return this.value;
    }

    public boolean isInWrite() {
        return this.type == ORMConstants.CALL_TYPE.IN || this.type == ORMConstants.CALL_TYPE.INOUT;
    }

    public boolean isOutRead() {
        return this.type == ORMConstants.CALL_TYPE.OUT || this.type == ORMConstants.CALL_TYPE.INOUT;
    }

    public int typeSQL() {
        return ZCall.getType(this.clazz);
    }

    public void value(CallableStatement cstmt, int index) throws SQLException {
        this.value = ZCall.getValue(this.clazz, cstmt, index);
    }

    public static CallParam in(Object value) {
        return new CallParam(ORMConstants.CALL_TYPE.IN, value);
    }

    public static CallParam inout(Object value) {
        return new CallParam(ORMConstants.CALL_TYPE.INOUT, value);
    }

    public static CallParam out(Class<?> clazz) {
        return new CallParam(ORMConstants.CALL_TYPE.OUT, clazz);
    }
}

