/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 角色表 对应表《ZMR_ROLE》
 */
@AnAlias("ZmrRole")
@AnNew
@AnTable(table="ZMR_ROLE", key="ROLE_ID", type="InnoDB")
public class ZmrRole implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="ORG_ID", type="long", notNull=true)    private long orgId;    //1.组织编号
    @AnTableField(column="ROLE_ID", type="long", notNull=true)    private long roleId;    //2.角色编号
    @AnTableField(column="ROLE_NAME", type="string,32", notNull=true)    private String roleName;    //3.角色名称
    @AnTableField(column="ROLE_STATUS", type="byte", notNull=true)    private int roleStatus;    //4.角色状态，0表示正常，1表示停用
    @AnTableField(column="ROLE_SEQ", type="int", notNull=true)    private int roleSeq;    //5.角色排序数

    public String toString()
    {
        return Jsons.toString(this);
    }

    public long getOrgId()
    {
        return orgId;
    }

    public void setOrgId(long orgId)
    {
        this.orgId = orgId;
    }

    public long getRoleId()
    {
        return roleId;
    }

    public void setRoleId(long roleId)
    {
        this.roleId = roleId;
    }

    public String getRoleName()
    {
        return roleName;
    }

    public void setRoleName(String roleName)
    {
        this.roleName = roleName;
    }

    public int getRoleStatus()
    {
        return roleStatus;
    }

    public void setRoleStatus(int roleStatus)
    {
        this.roleStatus = roleStatus;
    }

    public int getRoleSeq()
    {
        return roleSeq;
    }

    public void setRoleSeq(int roleSeq)
    {
        this.roleSeq = roleSeq;
    }

}
