/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Validates;

/**
 * "/zmi/*.htm"文件处理
 *
 * @version v1.0.0 @author zouzhigang 2018-1-18 新建与整理
 */
public class ZmiAction implements Action
{
    @Override
    public void execute(HttpRequest request) throws Exception
    {
        String zml = request.getContext().getResourceString("/ztmpl/zhiqim_manager/inner.htm");
        String content = ZmlContexts.parseZmlContent(request, zml, "include", request.getPathInContext());
        
        HttpResponse response = request.getResponse();
        if (response.isCommitted())
            return;
        
        if (!Validates.isEmpty(content))
            response.print(content);
        
        response.commit();
    }
}
