/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.util.Linux;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Systems;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.presenter.ZmrProcessPresenter;

/**
 * 堆栈信息查看类
 *
 * @version v1.0.0 @author liuhu 2018-9-7 新建与整理
 */
public class ProcessThreadStackAction implements Action
{
    public void execute(HttpRequest request) throws Exception
    {
        String javaHome = Global.getString("boot", "home");
        if (Validates.isEmptyBlank(javaHome))
            javaHome = Systems.getPropOrEnv("JAVA_HOME");
        javaHome = Strings.trimRight(javaHome, "/");
        
        String shell = new StringBuilder(javaHome).append("/bin/jstack -l ").append(Systems.getPid()).toString();
        String result = Linux.shell(shell, _UTF_8_);
        
        List<String> list = ZmrProcessPresenter.findThreadStack(result);
        StringBuilder stackInfo = new StringBuilder();
        int threadPid = Integer.valueOf(request.getParameter("threadPid"));
        
        for(String temp:list)
        {
            String tempPid = ZmrProcessPresenter.findPid(temp);
            if(tempPid.equals(Integer.toHexString(threadPid)))
            {
                stackInfo.append(temp);
                break;
            }
        }
        
        request.setAttribute("stackInfo", stackInfo.toString());
    }
}
