/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dbo.ZmrOperatorLog;
import org.zhiqim.orm.dbo.Selector;

/**
 * 操作日志查询
 * @version v1.0.0 @author zhouwenbin 2017-6-2 新建与整理
 */
public class OperateLogAction implements Action, ZmrConstants
{
    @Override
    public void execute(HttpRequest request) throws Exception
    {
        int page = request.getParameterInt("page", 1);
        int pageSize = request.getContextAttributeInt(ZMR_PAGE_SIZE, 20);
        String beginTime = request.getParameter("beginTime", DateTimes.getPreviousDateTimeString());
        String endTime = request.getParameter("endTime", DateTimes.getDateTimeString());
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        long orgId = sessionUser.getSelectedOrgId();
        
        Selector selector = new Selector();
        if (!sessionUser.isAdmin())
        {//操作员只能查看自己的
            selector.addMust("operatorCode", sessionUser.getOperatorCode());
        }
        else
        {//查操作员
            selector.addMaybe("operatorCode", request.getParameter("operatorCode"));
        }
        selector.addMaybeThenGE("operateTime", Sqls.toTimestamp(beginTime));
        selector.addMaybeThenLE("operateTime", Sqls.toTimestamp(endTime));
        selector.addOrderbyDesc("operateTime");
        selector.addMust("orgId", orgId);
        
        PageResult<ZmrOperatorLog> result = ZmrBootstrap.table(request).page(ZmrOperatorLog.class, page, pageSize, selector);
        result.addConditionMap(request.getParameterMap());
        
        request.setAttribute("result", result);
        request.setAttribute("startTime", beginTime);
        request.setAttribute("endTime", endTime);
    }

}
