/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.ones.IsIntegerValue;
import org.zhiqim.httpd.validate.ones.IsLen;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.httpd.validate.onex.IsInteger;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.kernel.tree.TreeBuilder;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrOperatorDao;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

/**
 * 功能菜单管理
 *
 * @version v1.0.0 @author zouzhigang 2015-5-28 新建与整理
 */
public class MenuAction  extends StdSwitchAction
{
    @Override
    protected void validateId(HttpRequest request)
    {
        request.addValidate(new IsNotEmpty("menuCode", "请选中一个菜单编码"));
    }

    @Override
    protected void validateForm(HttpRequest request)
    {
        request.addValidate(new IsNotEmpty("menuCode", "菜单编码不能为空，格式为MENU_开头的每3个数字和下划线组成的字符串"));
        request.addValidate(new IsNotEmpty("parentCode", "父菜单编码不能为空"));
        request.addValidate(new IsLen("menuName", "菜单名称不能为空且不能超过32个汉字", 1, 32));
        request.addValidate(new IsIntegerValue("menuStatus", "菜单状态范围为[0, 1]之间", 0, 1));
        request.addValidate(new IsIntegerValue("menuType", "菜单类型范围为[1, 2]之间", 1, 2));
        request.addValidate(new IsInteger("menuLevel", "菜单级别必须是整数"));
    }

    @Override
    protected void list(HttpRequest request) throws Exception
    {
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        
        List<ZmrMenu> list = sessionUser.getMenuList();
        Tree<ZmrMenu> tree = TreeBuilder.newTree(list, "parentCode", "menuCode");
        
        request.setAttribute("menuSize", list.size());
        request.setAttribute("tree", tree);
    }
    
    @Override
    protected void add(HttpRequest request) throws Exception
    {
        String menuCode = request.getParameter("menuCode");
        ZmrMenu item = ZmrBootstrap.table(request).item(ZmrMenu.class, menuCode);
        if (item == null)
        {// 获取菜单信息
            request.returnHistory("您选择的菜单不存在，请选择一个有效的菜单");
            return;
        }
        
        request.setAttribute("parent", item);
    }
    
    @Override
    protected void insert(HttpRequest request) throws Exception
    {
        String menuCode = request.getParameter("menuCode");
        String parentCode = request.getParameter("parentCode");
        
        if (!menuCode.startsWith(parentCode+"_"))
        {
            request.returnHistory("该菜单编号格式不对，没有从父菜单编码中继承");
            return;
        }
        
        String code = menuCode.substring(parentCode.length()+1);
        if (!Validates.isNumericLen(code, 3, 3))
        {
            request.returnHistory("该菜单编号格式不对，小编码为3位数字组成");
            return;
        }
        
        if (ZmrBootstrap.table(request).count(ZmrMenu.class, menuCode) > 0)
        {
            request.returnHistory("该菜单编号已存在，请重选一个");
            return;
        }
        
        //插入数据库
        ZmrMenu menu = request.getParameter(ZmrMenu.class);
        ZmrBootstrap.table(request).insert(menu);
        
        //更新自己的会话
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        List<ZmrMenu> menuList = ZmrOperatorDao.getOperatorMenuList(request, sessionUser.getOperator());
        sessionUser.setMenuList(request.getContext(), menuList);
    }
    
    @Override
    protected void modify(HttpRequest request) throws Exception
    {
        String menuCode = request.getParameter("menuCode");
        ZmrMenu item = ZmrBootstrap.table(request).item(ZmrMenu.class, menuCode);
        if (item == null)
        {// 获取菜单信息
            request.returnHistory("您选择的菜单不存在，请选择一个有效的菜单");
            return;
        }

        if (item.getMenuLevel() == 0)
        {
            request.returnHistory("系统功能根菜单不支持修改");
            return;
        }
        
        request.setAttribute("item", item);
    }

    @Override
    protected void update(HttpRequest request) throws Exception
    {
        String menuCode = request.getParameter("menuCode");
        if (ZmrBootstrap.table(request).count(ZmrMenu.class, menuCode) == 0)
        {
            request.returnHistory("你修改的菜单不存在，请选择有效的菜单进行修改");
            return;
        }
        
        String menuName = request.getParameter("menuName");
        int menuStatus = request.getParameterInt("menuStatus");
        String menuNameAbbr = request.getParameter("menuNameAbbr");
        int menuType = request.getParameterInt("menuType");
        String menuIcon = request.getParameter("menuIcon");
        String menuUrl = request.getParameter("menuUrl");
        String menuDesc = request.getParameter("menuDesc");

        //更新到数据库
        Updater updater = new Updater();
        updater.addMust("menuCode", menuCode);
        updater.addField("menuName", menuName);
        updater.addField("menuNameAbbr", menuNameAbbr);
        updater.addField("menuStatus", menuStatus);
        updater.addField("menuType", menuType);
        updater.addField("menuIcon", menuIcon);
        updater.addField("menuUrl", menuUrl);
        updater.addField("menuDesc", menuDesc);
        ZmrBootstrap.table(request).update(ZmrMenu.class, updater);
        
        //刷新所有在线用户会话
        ZmrOperatorDao.refresh(request);
    }

    @Override
    protected void delete(HttpRequest request) throws Exception
    {
        String menuCode = request.getParameter("menuCode");
        if (ZmrBootstrap.table(request).count(ZmrMenu.class, menuCode) == 0)
        {
            request.returnHistory("你修改的菜单不存在，请选择有效的菜单进行修改");
            return;
        }
        
        if (ZmrBootstrap.table(request).count(ZmrMenu.class, new Selector("parentCode", menuCode)) > 0)
        {
            request.returnHistory("你修改的菜单有子菜单，请先删除子菜单");
            return;
        }
        
        ZmrBootstrap.table(request).delete(ZmrMenu.class, menuCode);
        
        //刷新所有在线用户会话
        ZmrOperatorDao.refresh(request);
    }
    
    /*******************************************************************************/
    //暂不支持增加&删除
    /*******************************************************************************/

}
