/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlBootstrap;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.manager.ZmrBootstrapApi;
import org.zhiqim.manager.dao.ZmrParamDao;


/**
 * 操作员退出
 *
 * @version v1.0.0 @author zouzhigang 2015-5-28 新建与整理
 */
public class LogoutAction implements Action
{
    public void execute(HttpRequest request) throws Exception
    {
        //1.退出之前回调退出API
        Context context = (Context)request.getContext();
        ZmlBootstrap bootstrap = context.getBootstrap();
        if (bootstrap instanceof ZmrBootstrapApi)
        {
            ((ZmrBootstrapApi)bootstrap).logouting(request);
        }
        
        //2.解绑会话用户
        request.unbindSessionUser();
        
        //3.设置有管理登录页时，到管理登录页，否则到/index.htm
        if (ZmrParamDao.hasManageLogin(request.getContext()))
        {
            request.setRedirectInner("/"+request.getContextAttributeString("zhiqim_manager")+".htm");
        }
    }
}
