/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.ArrayList;
import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.GetPostAction;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrDeptDao;
import org.zhiqim.manager.dao.ZmrOrgDao;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrDeptRule;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.orm.dbo.Selector;

/**
 * 部门权限列表<br>
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class DeptRuleAction extends GetPostAction implements ZmrConstants
{
    protected void validate(HttpRequest request)
    {
        request.addValidate(new IsNotEmpty("deptId", "请选择部门"));
    }

    @Override
    protected void doGet(HttpRequest request) throws Exception
    {
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        long orgId = sessionUser.getSelectedOrgId();
        
        List<ZmrMenu> menuList = ZmrOrgDao.getMenuList(request, orgId);
        if (menuList.isEmpty())
        {
            request.setRedirect("/manager/dept.htm", "请先设置组织权限");
            return;
        }
        
        Tree<ZmrDept> tree = ZmrDeptDao.getOrgDeptTree(request, orgId);
        request.setAttribute("tree", tree);
    }

    @Override
    protected void doPost(HttpRequest request) throws Exception
    {
        long deptId = request.getParameterLong("deptId");
        String[] menuCodes = request.getParameterValuesOnCNT("rule");
        if (menuCodes == null)
            menuCodes = new String[0];
    
        // 判断部门是否存在
        if (ZmrBootstrap.table(request).count(ZmrDept.class, deptId) == 0)
        {
            request.returnHistory("您选择的部门不存在");
            return;
        }
    
        // 重置操作员权限
        ZmrBootstrap.table(request).delete(ZmrDeptRule.class, new Selector("deptId", deptId));
        if (menuCodes.length > 0)
        {
            List<ZmrDeptRule> bathList = new ArrayList<ZmrDeptRule>();
            for (int i = 0; i < menuCodes.length; i++)
            {
                ZmrDeptRule rule = new ZmrDeptRule();
                rule.setDeptId(deptId);
                rule.setMenuCode(menuCodes[i]);
                
                bathList.add(rule);
            }

            ZmrBootstrap.table(request).insertBatch(bathList);
        }
        
        //设置为当前选中
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        sessionUser.setValue(ZMR_SESSION_USER_DEPT_ID, deptId);
        
        request.setAlertMsg("保存成功");
    }
}
