/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.orm.dbo.Selector;

/**
 * 部门操作员选择器
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class DeptOperatorSelectorAction implements Action
{
    public void execute(HttpRequest request) throws Exception
    {
        request.setResponsePrivateCache();
        
        long deptId = request.getParameterLong("deptId");
        if (deptId == -1)
        {
            request.returnCloseDialog("您选择的部门不存在，请选择一个有效的部门");
            return;
        }

        //获取部门
        ZmrDept dept = ZmrBootstrap.table(request).item(ZmrDept.class, deptId);
        if (dept == null)
        {
            request.returnCloseDialog("您选择的部门不存在，请选择一个有效的部门");
            return;
        }
        
        //获取部门下未关联的所有操作员，管理员除外
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        Selector selector = new Selector();
        selector.addMust("orgId", dept.getOrgId());
        selector.addMustThenG("operatorType", sessionUser.getOperatorTypeThenG());
        
        String operatorKey = request.getParameter("operatorKey");
        if (Validates.isNotEmpty(operatorKey))
        {//条件
            selector.addOr(new Selector().addMaybeLike("operatorCode", operatorKey).addMaybeLike("operatorName", operatorKey));
        }
        
        selector.addOr(new Selector().addMaybeIsNull("operatorDept").addMustNotLike("operatorDept", deptId));
        List<ZmrOperator> operatorList = ZmrBootstrap.tableOpr(request).list(ZmrOperator.class, selector);
        
        request.setAttribute("dept", dept);
        request.setAttribute("operatorList", operatorList);
    }
}