/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.manager.dao.ZmrParamDao;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrOperatorLog;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

/**
 * 管理台任务
 * 1）检查超级管理员是否需要关闭
 * 2）删除保留时长之外的操作日志
 *
 * @version v1.0.0 @author zouzhigang 2017-7-19 新建与整理
 */
public class ZmrTask implements Task
{
    private static final Log log = LogFactory.getLog(ZmrTask.class);
    private ZmrBootstrap bootstrap;
    
    public ZmrTask(ZmrBootstrap bootstrap)
    {
        this.bootstrap = bootstrap;
    }
    
    @Override
    public void execute()
    {
        //检查超级管理员是否需要关闭
        chkCloseSuperAdmin();
        
        //删除保留时长之外的操作日志
        delExpireOperateLog();
    }
    
    /** 检查超级管理员是否需要关闭 */
    private void chkCloseSuperAdmin()
    {
        try
        {
            if (bootstrap.tableOpr().count(ZmrOperator.class, new Selector("operatorType", 0).addMust("operatorStatus", 0)) == 0)
            {//超级管理员已停用的不处理
                return;
            }
            
            if (bootstrap.tableOpr().count(ZmrOperator.class, new Selector("operatorType", 1).addMust("operatorStatus", 0)) == 0)
            {//如果没有正常的管理员，则不停用超级管理员
                return;
            }
            
            //有正常的管理员，则停用超级管理员
            bootstrap.tableOpr().update(ZmrOperator.class, new Updater().addField("operatorStatus", 1).addMust("operatorType", 0));
            log.info("停用超级管理员成功...");
        }
        catch (Exception e)
        {
            log.error("停用超级管理员时异常", e);
        }
    }
    
    /** 删除保留时长之外的操作日志 */
    private void delExpireOperateLog()
    {
        try
        {
            int remainDay = ZmrParamDao.getRemainLogDay(bootstrap.getContext());
            String datetime = DateTimes.getDateString() + " 00:00:00";
            String operateTime = DateTimes.getPreviousDateTimeString(datetime, remainDay);
            
            Selector selector = new Selector()
                .addMustThenL("operateTime", Sqls.toTimestamp(operateTime));
            
            bootstrap.table().delete(ZmrOperatorLog.class, selector);
            log.info("删除[%s]之前的操作日志成功...", operateTime);
        }
        catch (Exception e)
        {
            log.error("删除之前的操作日志时异常", e);
        }
    }
}
