/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager;

import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.MD5;
import org.zhiqim.kernel.util.codes.SHA256;

/**
 * 密码器，系统提供一个默认的SHA256的编码算法和HEX的简单加解密算法
 * 1、建议各系统编写一个子类重写该类的三个方法，并配置到zmr.passwroder中
 * 2、如果未打开保存密码功能，encrypt/decrypt可忽略
 *
 * @version v1.0.0 @author zhichenggang 2017-1-1 新建与整理
 */
public class ZmrPassworder implements ZmrConstants
{
    /**
     * 操作员密码不可逆编码，默认SHA256(name + code + pass + salt)
     * 
     * @param operatorCode      操作员编码
     * @param operatorPass      操作员密码
     * @param operatorPassSalt  操作员密码盐值
     * @return                  编码之后的密码
     */
    public String encode(String operatorCode, String operatorPass, String operatorPassSalt)
    {
        return SHA256.encodeUTF8(Z_NAME + operatorCode + operatorPass + operatorPassSalt);
    }
    
    /**
     * 密钥编码，默认MD5(name + code + salt)，取MD5前10 + len + 后20
     * 
     * @param operatorCode      操作员编码
     * @param operatorPass      操作员密码
     * @param operatorPassSalt  操作员密码盐值
     * @return                  编码之后的密码
     */
    public String secret(String operatorCode, String operatorPass, String operatorPassSalt)
    {
        String value = Strings.prefixZero(operatorPass.length(), 2);
        String md5 = MD5.encodeUTF8(Z_NAME + operatorCode + operatorPassSalt);
        return md5.substring(0, 10) + value + md5.substring(12);
    }
    
    /**
     * 验证密钥是否正确
     * 
     * @param operatorCode      操作员编码
     * @param operatorPass      操作员密码
     * @param operatorPassSalt  操作员密码盐值
     * @param operatorPassSecr  操作员存储的密钥
     * @return                  =true表示正确
     */
    public boolean secretChk(String operatorCode, String operatorPass, String operatorPassSalt, String operatorPassSecr)
    {
        if (secretLen(operatorPassSecr) != operatorPass.length())
            return false;
        
        return operatorPassSecr.equals(secret(operatorCode, operatorPass, operatorPassSalt));
    }
    
    /**
     * 取出密钥中的真实密码长度值
     * 
     * @param secret  操作员密码
     * @return              加密后密码
     */
    public int secretLen(String secret)
    {
        if (!Validates.isMD5String(secret))
            return 0;
        
        String value = secret.substring(10, 12);
        if (!Validates.isNumeric(value))
            return 0;
        
        return Ints.toInt(value);
    }
}
