/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.loader;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.util.Resources;

public class ClassZmlWatcher {
    private final Class<?> loadClass;
    private final String pathPrefix;
    private final HashMapSV<long[]> modifiedMap;

    public ClassZmlWatcher(Class<?> loadClass, String pathPrefix) {
        this.loadClass = loadClass;
        this.pathPrefix = pathPrefix;
        this.modifiedMap = new HashMapSV();
    }

    public long getLastModified(String path) {
        long[] value = (long[])this.modifiedMap.get(path);
        if (value != null && System.currentTimeMillis() - value[1] < 11000L) {
            return value[0];
        }
        URL url = Resources.getResource(this.loadClass, (String)(String.valueOf(this.pathPrefix) + path));
        if (url == null) {
            this.modifiedMap.remove(path);
            return -1L;
        }
        try {
            URLConnection conn = url.openConnection();
            long lastModified = conn.getLastModified();
            this.modifiedMap.put(path, (Object)new long[]{lastModified, System.currentTimeMillis()});
            return lastModified;
        }
        catch (IOException iOException) {
            this.modifiedMap.remove(path);
            return -1L;
        }
    }
}

