/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.expression.primitive;

import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.expression.Primitive;

public class _Char
extends Primitive {
    private final char value;

    public _Char(String value) {
        Asserts.as(Validates.isLen((String)value, (int)3, (int)4) ? null : "\u5b57\u7b26[" + value + "]\u683c\u5f0f\u4e0d\u5bf9");
        Asserts.as(value.startsWith("'") ? null : "\u5b57\u7b26[" + value + "]\u683c\u5f0f\u4e0d\u5bf9");
        Asserts.as(value.endsWith("'") ? null : "\u5b57\u7b26[" + value + "]\u683c\u5f0f\u4e0d\u5bf9");
        value = value.substring(1, value.length() - 1);
        if (value.length() == 1) {
            this.value = value.charAt(0);
            return;
        }
        Asserts.as(value.length() == 2 ? null : "\u5b57\u7b26[" + value + "]\u683c\u5f0f\u4e0d\u5bf9");
        Asserts.as('\\' == value.charAt(0) ? null : "\u5b57\u7b26[" + value + "]\u683c\u5f0f\u4e0d\u5bf9");
        char tc = value.charAt(1);
        switch (tc) {
            case '\\': {
                this.value = (char)92;
                break;
            }
            case '\"': {
                this.value = (char)34;
                break;
            }
            case '\'': {
                this.value = (char)39;
                break;
            }
            case 'b': {
                this.value = (char)8;
                break;
            }
            case 'f': {
                this.value = (char)12;
                break;
            }
            case 'n': {
                this.value = (char)10;
                break;
            }
            case 'r': {
                this.value = (char)13;
                break;
            }
            case 't': {
                this.value = (char)9;
                break;
            }
            default: {
                throw Asserts.exception((String)("\u5b57\u7b26[" + value + "]\u683c\u5f0f\u4e0d\u5bf9"));
            }
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public Object build(ZmlVariable variableMap) throws ExpressionException {
        return Character.valueOf(this.value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    public char getValue() {
        return this.value;
    }
}

