/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.Statement;
import org.zhiqim.zml.StatementNesting;
import org.zhiqim.zml.Zml;
import org.zhiqim.zml.ZmlConstants;
import org.zhiqim.zml.ZmlLineIndex;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.StatementException;
import org.zhiqim.zml.statement._Break;
import org.zhiqim.zml.statement._Call;
import org.zhiqim.zml.statement._Comment;
import org.zhiqim.zml.statement._Continue;
import org.zhiqim.zml.statement._Define;
import org.zhiqim.zml.statement._Echo;
import org.zhiqim.zml.statement._For;
import org.zhiqim.zml.statement._Format;
import org.zhiqim.zml.statement._Function;
import org.zhiqim.zml.statement._If;
import org.zhiqim.zml.statement._Include;
import org.zhiqim.zml.statement._Interceptor;
import org.zhiqim.zml.statement._Return;
import org.zhiqim.zml.statement._Text;
import org.zhiqim.zml.statement._Var;

public class StatementParser
implements ZmlConstants,
SignConstants {
    public static void parseContextZml(Zml zml, List<_Function> _functionList, List<_Var> _varList, List<_Include> _includeList) throws StatementException {
        List<_Function> functionList = StatementParser.getStatementOutLineAndNesting(zml, _Function.class, "<#function>", "<#function ", "</#function>");
        List<_Comment> commentList = StatementParser.getStatementOutLineAndNesting(zml, _Comment.class, "<#---->", "<#--", "-->");
        List<_Var> varList = StatementParser.getStatementListInLine(zml, _Var.class, "<#var>", "<#var ", "/>");
        List<_Include> includeList = StatementParser.getStatementListInLine(zml, _Include.class, "<#include>", "<#include ", "/>");
        Iterator<Statement> it = functionList.iterator();
        while (it.hasNext()) {
            _Function _function = it.next();
            if (!StatementParser.isInCommentStatement(_function, commentList)) continue;
            it.remove();
        }
        it = varList.iterator();
        while (it.hasNext()) {
            _Var _var = (_Var)it.next();
            if (!StatementParser.isInFunctionStatement(_var, functionList) && !StatementParser.isInCommentStatement(_var, commentList)) continue;
            it.remove();
        }
        it = includeList.iterator();
        while (it.hasNext()) {
            _Include _include = (_Include)it.next();
            if (!StatementParser.isInFunctionStatement(_include, functionList) && !StatementParser.isInCommentStatement(_include, commentList)) continue;
            it.remove();
        }
        _functionList.addAll(functionList);
        _varList.addAll(varList);
        _includeList.addAll(includeList);
    }

    public static List<Statement> parseStatementNesting(StatementNesting nesting) throws StatementException {
        _Text _txt;
        String statement;
        List<_Function> functionList = StatementParser.getStatementOutLineAndNesting(nesting, _Function.class, "<#function>", "<#function ", "</#function>");
        List<_For> forList = StatementParser.getStatementOutLineAndNesting(nesting, _For.class, "<#for>", "<#for ", "</#for>");
        List<_If> ifList = StatementParser.getStatementOutLineAndNesting(nesting, _If.class, "<#if>", "<#if ", "</#if>");
        List<_Comment> commentList = StatementParser.getStatementOutLineAndNesting(nesting, _Comment.class, "<#---->", "<#--", "-->");
        List<_Include> includeList = StatementParser.getStatementListInLine(nesting, _Include.class, "<#include>", "<#include ", "/>");
        List<_Interceptor> interceptorList = StatementParser.getStatementListInLine(nesting, _Interceptor.class, "<#interceptor>", "<#interceptor ", "/>");
        List<_Var> varList = StatementParser.getStatementListInLine(nesting, _Var.class, "<#var>", "<#var ", "/>");
        List<_Define> defList = StatementParser.getStatementListInLine(nesting, _Define.class, "<#def>", "<#def ", "/>");
        List<_Echo> echoList = StatementParser.getStatementListInLine(nesting, _Echo.class, "${}", "${", "}");
        List<_Format> formatList = StatementParser.getStatementListInLine(nesting, _Format.class, "#{}", "#{", "}");
        List<_Call> callList = StatementParser.getStatementListInLine(nesting, _Call.class, "@{}", "@{", "}");
        List<_Return> returnList = StatementParser.getStatementListInLine(nesting, _Return.class, "<#return>", "<#return", "/>");
        List<_Break> breakList = StatementParser.getStatementListInLine(nesting, _Break.class, "<#break/>", "<#break", "/>");
        List<_Continue> continueList = StatementParser.getStatementListInLine(nesting, _Continue.class, "<#continue/>", "<#continue", "/>");
        Iterator<Statement> it = returnList.iterator();
        while (it.hasNext()) {
            _Return _return = it.next();
            if (!StatementParser.isInFunctionStatement(_return, functionList) && !StatementParser.isInForStatement(_return, forList) && !StatementParser.isInIfStatement(_return, ifList) && !StatementParser.isInCommentStatement(_return, commentList)) continue;
            it.remove();
        }
        it = breakList.iterator();
        while (it.hasNext()) {
            _Break _break = (_Break)it.next();
            if (!StatementParser.isInFunctionStatement(_break, functionList) && !StatementParser.isInForStatement(_break, forList) && !StatementParser.isInIfStatement(_break, ifList) && !StatementParser.isInCommentStatement(_break, commentList)) continue;
            it.remove();
        }
        it = continueList.iterator();
        while (it.hasNext()) {
            _Continue _continue = (_Continue)it.next();
            if (!StatementParser.isInFunctionStatement(_continue, functionList) && !StatementParser.isInForStatement(_continue, forList) && !StatementParser.isInIfStatement(_continue, ifList) && !StatementParser.isInCommentStatement(_continue, commentList)) continue;
            it.remove();
        }
        it = includeList.iterator();
        while (it.hasNext()) {
            _Include _include = (_Include)it.next();
            if (!StatementParser.isInFunctionStatement(_include, functionList) && !StatementParser.isInForStatement(_include, forList) && !StatementParser.isInIfStatement(_include, ifList) && !StatementParser.isInCommentStatement(_include, commentList)) continue;
            it.remove();
        }
        it = varList.iterator();
        while (it.hasNext()) {
            _Var _var = (_Var)it.next();
            if (!StatementParser.isInFunctionStatement(_var, functionList) && !StatementParser.isInForStatement(_var, forList) && !StatementParser.isInIfStatement(_var, ifList) && !StatementParser.isInCommentStatement(_var, commentList)) continue;
            it.remove();
        }
        it = defList.iterator();
        while (it.hasNext()) {
            _Define _def = (_Define)it.next();
            if (!StatementParser.isInFunctionStatement(_def, functionList) && !StatementParser.isInForStatement(_def, forList) && !StatementParser.isInIfStatement(_def, ifList) && !StatementParser.isInCommentStatement(_def, commentList)) continue;
            it.remove();
        }
        it = echoList.iterator();
        while (it.hasNext()) {
            _Echo _echo = (_Echo)it.next();
            if (!StatementParser.isInFunctionStatement(_echo, functionList) && !StatementParser.isInForStatement(_echo, forList) && !StatementParser.isInIfStatement(_echo, ifList) && !StatementParser.isInCommentStatement(_echo, commentList)) continue;
            it.remove();
        }
        it = formatList.iterator();
        while (it.hasNext()) {
            _Format _format = (_Format)it.next();
            if (!StatementParser.isInFunctionStatement(_format, functionList) && !StatementParser.isInForStatement(_format, forList) && !StatementParser.isInIfStatement(_format, ifList) && !StatementParser.isInCommentStatement(_format, commentList)) continue;
            it.remove();
        }
        it = callList.iterator();
        while (it.hasNext()) {
            _Call _call = (_Call)it.next();
            if (!StatementParser.isInFunctionStatement(_call, functionList) && !StatementParser.isInForStatement(_call, forList) && !StatementParser.isInIfStatement(_call, ifList) && !StatementParser.isInCommentStatement(_call, commentList)) continue;
            it.remove();
        }
        it = functionList.iterator();
        while (it.hasNext()) {
            _Function _function = (_Function)it.next();
            if (!StatementParser.isInIfStatement(_function, ifList) && !StatementParser.isInForStatement(_function, forList) && !StatementParser.isInCommentStatement(_function, commentList)) continue;
            it.remove();
        }
        it = ifList.iterator();
        while (it.hasNext()) {
            _If _if = (_If)it.next();
            if (!StatementParser.isInFunctionStatement(_if, functionList) && !StatementParser.isInForStatement(_if, forList) && !StatementParser.isInCommentStatement(_if, commentList)) continue;
            it.remove();
        }
        it = forList.iterator();
        while (it.hasNext()) {
            _For _for = (_For)it.next();
            if (!StatementParser.isInFunctionStatement(_for, functionList) && !StatementParser.isInIfStatement(_for, ifList) && !StatementParser.isInCommentStatement(_for, commentList)) continue;
            it.remove();
        }
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        statementList.addAll(functionList);
        statementList.addAll(forList);
        statementList.addAll(ifList);
        statementList.addAll(commentList);
        statementList.addAll(includeList);
        statementList.addAll(interceptorList);
        statementList.addAll(varList);
        statementList.addAll(defList);
        statementList.addAll(echoList);
        statementList.addAll(formatList);
        statementList.addAll(callList);
        statementList.addAll(returnList);
        statementList.addAll(breakList);
        statementList.addAll(continueList);
        statementList.trimToSize();
        Collections.sort(statementList, Statement.COMPARATOR);
        if (statementList.isEmpty()) {
            String content = nesting.getContent();
            _Text _txt2 = new _Text();
            _txt2.setStatement(nesting.getZml(), nesting, content);
            _txt2.setIndexInner(0, content.length());
            _txt2.setIndexAll(nesting.getContentBeginIndex(), nesting.getContentBeginIndex() + content.length());
            ArrayList<Statement> tsList = new ArrayList<Statement>(1);
            tsList.add(_txt2);
            return tsList;
        }
        ArrayList<Statement> tsList = new ArrayList<Statement>(statementList.size() * 2);
        String content = nesting.getContent();
        Statement lastTs = (Statement)statementList.get(0);
        if (lastTs.getBeginIndex() > 0 && !Validates.isEmpty((String)(statement = content.substring(0, lastTs.getInnerBeginIndex())))) {
            _txt = new _Text();
            _txt.setStatement(nesting.getZml(), nesting, statement);
            _txt.setIndexInner(0, lastTs.getInnerBeginIndex());
            _txt.setIndexAll(nesting.getContentBeginIndex(), nesting.getContentBeginIndex() + lastTs.getInnerBeginIndex());
            tsList.add(_txt);
        }
        tsList.add(lastTs);
        int i = 1;
        while (i < statementList.size()) {
            String statement2;
            Statement ts = (Statement)statementList.get(i);
            if (ts.getBeginIndex() > lastTs.getEndIndex() && !Validates.isEmpty((String)(statement2 = content.substring(lastTs.getInnerEndIndex(), ts.getInnerBeginIndex())))) {
                _Text _txt3 = new _Text();
                _txt3.setStatement(nesting.getZml(), nesting, statement2);
                _txt3.setIndexInner(lastTs.getInnerEndIndex(), ts.getInnerBeginIndex());
                _txt3.setIndexAll(nesting.getContentBeginIndex() + lastTs.getInnerEndIndex(), nesting.getContentBeginIndex() + ts.getInnerBeginIndex());
                tsList.add(_txt3);
            }
            tsList.add(ts);
            lastTs = ts;
            ++i;
        }
        if (lastTs.getInnerEndIndex() < content.length() && !Validates.isEmpty((String)(statement = content.substring(lastTs.getInnerEndIndex(), content.length())))) {
            _txt = new _Text();
            _txt.setStatement(nesting.getZml(), nesting, statement);
            _txt.setIndexInner(lastTs.getInnerEndIndex(), content.length());
            _txt.setIndexAll(nesting.getContentBeginIndex() + lastTs.getInnerEndIndex(), nesting.getContentBeginIndex() + content.length());
            tsList.add(_txt);
        }
        tsList.trimToSize();
        return tsList;
    }

    public static <T> List<T> getStatementOutLineAndNesting(StatementNesting nesting, Class<T> cls, String name, String begin, String end) throws StatementException {
        String content = nesting.getContent();
        List<ZmlLineIndex> indexList = nesting.getIndexList();
        int indBegin = 0;
        int indEnd = 0;
        ArrayList<Object> statementList = new ArrayList<Object>();
        while ((indBegin = content.indexOf(begin, indEnd)) != -1) {
            int indEndTemp;
            int indBeginTemp = indBegin;
            int indNest = indBegin;
            while (true) {
                if ((indEndTemp = content.indexOf(end, indBeginTemp)) == -1) {
                    int[] begins = StatementParser.getLineColumnNoByIndex(indexList, indBegin + nesting.getContentBeginIndex());
                    throw new StatementException(nesting.getPath(), begins[0], begins[1], "\u68c0\u67e5" + name + "\u65f6\u672a\u627e\u5230" + end + "\u7ed3\u5c3e");
                }
                if ((indNest = content.indexOf(begin, indNest + begin.length())) == -1 || indNest > indEndTemp) break;
                indBeginTemp = indEndTemp + end.length();
            }
            indEnd = indEndTemp + end.length();
            String statement = content.substring(indBegin, indEnd);
            Object obj = Classes.newInstance(cls);
            Statement stmt = (Statement)obj;
            stmt.setStatement(nesting.getZml(), nesting, statement);
            stmt.setIndexInner(indBegin, indEnd);
            stmt.setIndexAll(nesting.getContentBeginIndex() + indBegin, nesting.getContentBeginIndex() + indEnd);
            stmt.parseStatement();
            statementList.add(obj);
        }
        return statementList;
    }

    public static <T> List<T> getStatementListInLine(StatementNesting nesting, Class<T> cls, String name, String begin, String end) throws StatementException {
        String content = nesting.getContent();
        List<ZmlLineIndex> indexList = nesting.getIndexList();
        int indBegin = 0;
        int indEnd = 0;
        ArrayList<Object> list = new ArrayList<Object>();
        while ((indBegin = content.indexOf(begin, indEnd)) != -1) {
            int[] ends;
            int[] begins;
            indEnd = content.indexOf(end, indBegin);
            if (indEnd == -1) {
                begins = StatementParser.getLineColumnNoByIndex(indexList, indBegin + nesting.getContentBeginIndex());
                throw new StatementException(nesting.getPath(), begins[0], begins[1], "\u68c0\u67e5" + name + "\u65f6\u672a\u627e\u5230" + end + "\u7ed3\u5c3e");
            }
            begins = StatementParser.getLineColumnNoByIndex(indexList, indBegin + nesting.getContentBeginIndex());
            if (begins[0] != (ends = StatementParser.getLineColumnNoByIndex(indexList, (indEnd += end.length()) + nesting.getContentBeginIndex()))[0]) {
                throw new StatementException(nesting.getPath(), begins[0], begins[1], "\u68c0\u67e5" + name + "\u65f6\u627e\u5230" + end + "\u4e0d\u5728\u540c\u4e00\u884c");
            }
            String statement = content.substring(indBegin, indEnd);
            Object obj = Classes.newInstance(cls);
            Statement stmt = (Statement)obj;
            stmt.setStatement(nesting.getZml(), nesting, statement);
            stmt.setIndexInner(indBegin, indEnd);
            stmt.setIndexAll(nesting.getContentBeginIndex() + indBegin, nesting.getContentBeginIndex() + indEnd);
            stmt.parseStatement();
            list.add(obj);
        }
        list.trimToSize();
        return list;
    }

    public static List<ZmlLineIndex> getIndexList(String content) {
        int index = 0;
        int lineNo = 0;
        ArrayList<ZmlLineIndex> indexList = new ArrayList<ZmlLineIndex>();
        StringTokenizer tokener = new StringTokenizer(content, "\r\n", true);
        while (tokener.hasMoreTokens()) {
            String line = tokener.nextToken();
            if ("\n".equals(line) || "\r".equals(line)) {
                ++index;
                continue;
            }
            ZmlLineIndex lineIndex = new ZmlLineIndex();
            lineIndex.setLineNo(++lineNo);
            lineIndex.setBeginIndex(index);
            lineIndex.setEndIndex(index += line.length());
            indexList.add(lineIndex);
        }
        indexList.trimToSize();
        return indexList;
    }

    public static int[] getLineColumnNoByIndex(List<ZmlLineIndex> indexList, int index) {
        int lineNo = -1;
        int columnNo = -1;
        for (ZmlLineIndex lineIndex : indexList) {
            lineNo = lineIndex.getLineNo(index);
            if (lineNo == -1) continue;
            columnNo = lineIndex.getColumnNo(index);
            break;
        }
        return new int[]{lineNo, columnNo};
    }

    public static boolean isInFunctionStatement(Statement ts, List<_Function> functionList) {
        for (_Function _function : functionList) {
            if (ts.getBeginIndex() <= _function.getBeginIndex() || ts.getEndIndex() >= _function.getEndIndex()) continue;
            return true;
        }
        return false;
    }

    public static boolean isInIfStatement(Statement ts, List<_If> ifList) {
        for (_If _if : ifList) {
            if (ts.getBeginIndex() <= _if.getBeginIndex() || ts.getEndIndex() >= _if.getEndIndex()) continue;
            return true;
        }
        return false;
    }

    public static boolean isInForStatement(Statement ts, List<_For> forList) {
        for (_For _for : forList) {
            if (ts.getBeginIndex() < _for.getBeginIndex() || ts.getEndIndex() > _for.getEndIndex()) continue;
            return true;
        }
        return false;
    }

    public static boolean isInCommentStatement(Statement ts, List<_Comment> commentList) {
        for (_Comment _comment : commentList) {
            if (ts.getBeginIndex() <= _comment.getBeginIndex() || ts.getEndIndex() >= _comment.getEndIndex()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasVar(List<Statement> stList) {
        for (Statement st : stList) {
            if (!(st instanceof _Var)) continue;
            return true;
        }
        return false;
    }

    public static void processStatementList(List<Statement> statementList, ZmlVariable variableMap, StringBuilder strb) throws StatementException {
        Statement last = null;
        for (Statement stmt : statementList) {
            _For _for;
            if (stmt instanceof _Return) {
                last = stmt;
                throw new _Return.ReturnException(((_Return)stmt).build(variableMap));
            }
            if (stmt instanceof _Break) {
                last = stmt;
                _for = stmt.getNearestNestingFor();
                if (_for == null) continue;
                throw new _Break.BreakException();
            }
            if (stmt instanceof _Continue) {
                last = stmt;
                _for = stmt.getNearestNestingFor();
                if (_for == null) continue;
                throw new _Continue.ContinueException();
            }
            String text = stmt.process(variableMap);
            if (Validates.isEmpty((String)text)) {
                if (stmt.isExclusiveLine()) {
                    Strings.removeRightMaybeEmptyBlankLine((StringBuilder)strb);
                }
            } else {
                if (stmt.isNesting() && stmt.isExclusiveLine()) {
                    Strings.removeRightMaybeEmptyBlank((StringBuilder)strb);
                }
                if (stmt instanceof _Text && strb.length() == 0 && last != null && last.isExclusiveLine()) {
                    text = Strings.trimLeftOneBR((String)text);
                }
                strb.append(text);
            }
            last = stmt;
        }
    }
}

