/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml;

import java.util.ArrayList;
import java.util.ListIterator;
import org.zhiqim.kernel.util.Types;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ExpressionPair;
import org.zhiqim.zml.ZmlConstants;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.expression.Operator;
import org.zhiqim.zml.expression.operator._Add;
import org.zhiqim.zml.expression.operator._And;
import org.zhiqim.zml.expression.operator._Bracket;
import org.zhiqim.zml.expression.operator._Division;
import org.zhiqim.zml.expression.operator._EqualEqual;
import org.zhiqim.zml.expression.operator._EqualNot;
import org.zhiqim.zml.expression.operator._GreateThen;
import org.zhiqim.zml.expression.operator._GreateThenEqual;
import org.zhiqim.zml.expression.operator._Indexable;
import org.zhiqim.zml.expression.operator._IntegerArray;
import org.zhiqim.zml.expression.operator._LessThen;
import org.zhiqim.zml.expression.operator._LessThenEqual;
import org.zhiqim.zml.expression.operator._Method;
import org.zhiqim.zml.expression.operator._Modulus;
import org.zhiqim.zml.expression.operator._Multiplication;
import org.zhiqim.zml.expression.operator._Negative;
import org.zhiqim.zml.expression.operator._New;
import org.zhiqim.zml.expression.operator._Not;
import org.zhiqim.zml.expression.operator._Or;
import org.zhiqim.zml.expression.operator._Subtraction;
import org.zhiqim.zml.expression.operator._Ternary;
import org.zhiqim.zml.expression.primitive._Boolean;
import org.zhiqim.zml.expression.primitive._Char;
import org.zhiqim.zml.expression.primitive._Class;
import org.zhiqim.zml.expression.primitive._Decimal;
import org.zhiqim.zml.expression.primitive._Integer;
import org.zhiqim.zml.expression.primitive._Null;
import org.zhiqim.zml.expression.primitive._String;
import org.zhiqim.zml.expression.primitive._Variable;
import org.zhiqim.zml.expression.symbol._Ampersand;
import org.zhiqim.zml.expression.symbol._Asterisk;
import org.zhiqim.zml.expression.symbol._CloseBracket;
import org.zhiqim.zml.expression.symbol._CloseParenthesis;
import org.zhiqim.zml.expression.symbol._Colon;
import org.zhiqim.zml.expression.symbol._Comma;
import org.zhiqim.zml.expression.symbol._Dot;
import org.zhiqim.zml.expression.symbol._DotDot;
import org.zhiqim.zml.expression.symbol._Equal;
import org.zhiqim.zml.expression.symbol._Exclamation;
import org.zhiqim.zml.expression.symbol._Gt;
import org.zhiqim.zml.expression.symbol._Gte;
import org.zhiqim.zml.expression.symbol._Inequal;
import org.zhiqim.zml.expression.symbol._Lt;
import org.zhiqim.zml.expression.symbol._Lte;
import org.zhiqim.zml.expression.symbol._Minus;
import org.zhiqim.zml.expression.symbol._OpenBracket;
import org.zhiqim.zml.expression.symbol._OpenParenthesis;
import org.zhiqim.zml.expression.symbol._Percent;
import org.zhiqim.zml.expression.symbol._Plus;
import org.zhiqim.zml.expression.symbol._Question;
import org.zhiqim.zml.expression.symbol._Slash;
import org.zhiqim.zml.expression.symbol._VerticalBar;

public class ExpressionParser
implements ZmlConstants {
    public static Expression parseExpression(String expression) throws ExpressionException {
        ArrayList<Object> charList;
        Object obj;
        ArrayList<Object> list = ExpressionParser.parse_String(expression);
        ListIterator<Object> it = list.listIterator();
        while (it.hasNext()) {
            obj = it.next();
            if (!(obj instanceof String)) continue;
            it.remove();
            charList = ExpressionParser.parse_Char((String)obj);
            for (Object value : charList) {
                it.add(value);
            }
        }
        it = list.listIterator();
        while (it.hasNext()) {
            obj = it.next();
            if (!(obj instanceof String)) continue;
            it.remove();
            charList = ExpressionParser.parse_Numberic((String)obj);
            for (Object value : charList) {
                it.add(value);
            }
        }
        it = list.listIterator();
        while (it.hasNext()) {
            obj = it.next();
            if (!(obj instanceof String)) continue;
            it.remove();
            charList = ExpressionParser.parse_Variable((String)obj);
            for (Object value : charList) {
                it.add(value);
            }
        }
        ArrayList<Expression> eList = ExpressionParser.parse_Symbol(list);
        ExpressionParser.parse_Operator(eList);
        if (eList.size() > 1) {
            throw new ExpressionException("\u5b58\u5728\u65e0\u6cd5\u5904\u7406\u7684\u8868\u8fbe\u5f0f");
        }
        Expression _expression = eList.get(0);
        eList.clear();
        eList = null;
        list.clear();
        list = null;
        return _expression;
    }

    public static void parse_Operator(ArrayList<Expression> eList) throws ExpressionException {
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_Bracket(eList);
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_BracketSquare(eList);
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_DotIndexable(eList);
        ExpressionParser.parse_DotDot(eList);
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_Not(eList);
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_Negative(eList);
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_New(eList);
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_MuliplicationDivisionModulus(eList);
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_AddSubtraction(eList);
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_GtGteLtLte(eList);
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_EqualEqualNot(eList);
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_AndOr(eList, 38);
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_AndOr(eList, 124);
        if (eList.size() <= 1) {
            return;
        }
        ExpressionParser.parse_Ternary(eList);
    }

    public static void parse_Ternary(ArrayList<Expression> eList) throws ExpressionException {
        boolean isDoLoop = false;
        int i = eList.size() - 1;
        while (i >= 0) {
            Expression expression = eList.get(i);
            if (expression.getType() == 58) {
                if (i == eList.size() - 1 || i < 2) {
                    throw new ExpressionException("58\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u524d\u9762\u6216\u540e\u9762\u65e0\u5185\u5bb9");
                }
                Expression colon = eList.get(i - 2);
                if (colon.getType() != 63) {
                    throw new ExpressionException("58\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u524d\u9762\u6ca1\u627e\u5230\u7b26\u53f7(?)");
                }
                Expression condition = eList.get(i - 3);
                Expression first = eList.get(i - 1);
                Expression second = eList.get(i + 1);
                _Ternary _tarnary = new _Ternary(condition, first, second);
                eList.remove(i);
                eList.remove(i);
                eList.remove(i - 1);
                eList.remove(i - 2);
                eList.remove(i - 3);
                eList.add(i - 3, _tarnary);
                isDoLoop = true;
                break;
            }
            --i;
        }
        if (isDoLoop) {
            ExpressionParser.parse_Ternary(eList);
        }
        eList.trimToSize();
    }

    public static void parse_AndOr(ArrayList<Expression> eList, int oprType) throws ExpressionException {
        boolean isDoLoop = false;
        int i = 0;
        while (i < eList.size()) {
            Expression expression = eList.get(i);
            if (expression.getType() == oprType) {
                if (i == 0 || i == eList.size() - 1) {
                    throw new ExpressionException(String.valueOf(oprType == 38 ? "\u903b\u8f91\u4e0e&&" : "\u903b\u8f91\u6216||") + "\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u524d\u9762\u6216\u540e\u9762\u65e0\u5185\u5bb9");
                }
                Expression last = eList.get(i - 1);
                Expression next = eList.get(i + 1);
                Operator _te = null;
                switch (oprType) {
                    case 38: {
                        _te = new _And(last, next);
                        break;
                    }
                    case 124: {
                        _te = new _Or(last, next);
                    }
                }
                eList.remove(i);
                eList.remove(i);
                eList.remove(i - 1);
                eList.add(i - 1, _te);
                isDoLoop = true;
                break;
            }
            ++i;
        }
        if (isDoLoop) {
            ExpressionParser.parse_AndOr(eList, oprType);
        }
        eList.trimToSize();
    }

    public static void parse_EqualEqualNot(ArrayList<Expression> eList) throws ExpressionException {
        boolean isDoLoop = false;
        int i = 0;
        while (i < eList.size()) {
            Expression expression = eList.get(i);
            int type = expression.getType();
            if (type == 61 || type == 3361) {
                if (i == 0 || i == eList.size() - 1) {
                    throw new ExpressionException("\u6052\u7b49\u548c\u4e0d\u7b49\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u524d\u9762\u6216\u540e\u9762\u65e0\u5185\u5bb9");
                }
                Expression last = eList.get(i - 1);
                Expression next = eList.get(i + 1);
                Operator _te = null;
                switch (type) {
                    case 61: {
                        _te = new _EqualEqual(last, next);
                        break;
                    }
                    case 3361: {
                        _te = new _EqualNot(last, next);
                    }
                }
                eList.remove(i);
                eList.remove(i);
                eList.remove(i - 1);
                eList.add(i - 1, _te);
                isDoLoop = true;
                break;
            }
            ++i;
        }
        if (isDoLoop) {
            ExpressionParser.parse_EqualEqualNot(eList);
        }
        eList.trimToSize();
    }

    public static void parse_GtGteLtLte(ArrayList<Expression> eList) throws ExpressionException {
        boolean isDoLoop = false;
        int i = 0;
        while (i < eList.size()) {
            Expression expression = eList.get(i);
            int type = expression.getType();
            if (type == 11 || type == 12 || type == 13 || type == 14) {
                if (i == 0 || i == eList.size() - 1) {
                    throw new ExpressionException("\u5927\u4e8e\u3001\u5927\u4e8e\u7b49\u4e8e\u3001\u5c0f\u4e8e\u3001\u5c0f\u4e8e\u7b49\u4e8e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u524d\u9762\u6216\u540e\u9762\u65e0\u5185\u5bb9");
                }
                Expression last = eList.get(i - 1);
                Expression next = eList.get(i + 1);
                Operator _te = null;
                switch (type) {
                    case 11: {
                        _te = new _GreateThen(last, next);
                        break;
                    }
                    case 12: {
                        _te = new _GreateThenEqual(last, next);
                        break;
                    }
                    case 13: {
                        _te = new _LessThen(last, next);
                        break;
                    }
                    case 14: {
                        _te = new _LessThenEqual(last, next);
                    }
                }
                eList.remove(i);
                eList.remove(i);
                eList.remove(i - 1);
                eList.add(i - 1, _te);
                isDoLoop = true;
                break;
            }
            ++i;
        }
        if (isDoLoop) {
            ExpressionParser.parse_GtGteLtLte(eList);
        }
        eList.trimToSize();
    }

    public static void parse_AddSubtraction(ArrayList<Expression> eList) throws ExpressionException {
        boolean isDoLoop = false;
        int i = 0;
        while (i < eList.size()) {
            Expression expression = eList.get(i);
            if (expression.getType() == 43 || expression.getType() == 45) {
                if (i == 0 || i == eList.size() - 1) {
                    throw new ExpressionException("\u52a0\u51cf\u6cd5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u524d\u9762\u6216\u540e\u9762\u65e0\u5185\u5bb9");
                }
                Expression last = eList.get(i - 1);
                Expression next = eList.get(i + 1);
                Operator _te = null;
                switch (expression.getType()) {
                    case 43: {
                        _te = new _Add(last, next);
                        break;
                    }
                    case 45: {
                        _te = new _Subtraction(last, next);
                    }
                }
                eList.remove(i);
                eList.remove(i);
                eList.remove(i - 1);
                eList.add(i - 1, _te);
                isDoLoop = true;
                break;
            }
            ++i;
        }
        if (isDoLoop) {
            ExpressionParser.parse_AddSubtraction(eList);
        }
        eList.trimToSize();
    }

    public static void parse_MuliplicationDivisionModulus(ArrayList<Expression> eList) throws ExpressionException {
        boolean isDoLoop = false;
        int i = 0;
        while (i < eList.size()) {
            Expression expression = eList.get(i);
            int type = expression.getType();
            if (type == 42 || type == 47 || type == 37) {
                if (i == 0 || i == eList.size() - 1) {
                    throw new ExpressionException("\u4e58\u9664\u8868\u8fbe\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u524d\u9762\u6216\u540e\u9762\u65e0\u5185\u5bb9");
                }
                Expression last = eList.get(i - 1);
                Expression next = eList.get(i + 1);
                Operator _te = null;
                switch (type) {
                    case 42: {
                        _te = new _Multiplication(last, next);
                        break;
                    }
                    case 47: {
                        _te = new _Division(last, next);
                        break;
                    }
                    case 37: {
                        _te = new _Modulus(last, next);
                    }
                }
                eList.remove(i);
                eList.remove(i);
                eList.remove(i - 1);
                eList.add(i - 1, _te);
                isDoLoop = true;
                break;
            }
            ++i;
        }
        if (isDoLoop) {
            ExpressionParser.parse_MuliplicationDivisionModulus(eList);
        }
        eList.trimToSize();
    }

    public static void parse_New(ArrayList<Expression> eList) throws ExpressionException {
        boolean isDoLoop = false;
        int i = 0;
        while (i < eList.size()) {
            Expression expression = eList.get(i);
            if (expression.getType() == 110101119) {
                if (i == eList.size() - 1) {
                    throw new ExpressionException("new\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u540e\u9762\u65e0\u6784\u9020\u65b9\u6cd5");
                }
                Expression next = eList.get(i + 1);
                if (next.getType() != 40410) {
                    throw new ExpressionException("new\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u540e\u9762\u4e0d\u662f\u65b9\u6cd5");
                }
                _Method _method = (_Method)next;
                Expression _variable = _method.getObject();
                if (_variable != null && !(_variable instanceof _Variable)) {
                    throw new ExpressionException("new\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u540e\u9762\u7684\u7c7b\u540d\u4e0d\u6b63\u786e");
                }
                String className = _variable == null ? _method.getMethodName() : String.valueOf(((_Variable)_variable).getValue()) + "." + _method.getMethodName();
                _method.setNew(expression, className);
                eList.remove(i);
                isDoLoop = true;
                break;
            }
            ++i;
        }
        if (isDoLoop) {
            ExpressionParser.parse_New(eList);
        }
        eList.trimToSize();
    }

    public static void parse_Negative(ArrayList<Expression> eList) throws ExpressionException {
        boolean isDoLoop = false;
        int i = 0;
        while (i < eList.size()) {
            Expression expression = eList.get(i);
            if (expression.getType() == 45) {
                Expression next;
                Expression last;
                int type;
                if (i == eList.size() - 1) {
                    throw new ExpressionException("\u51cf\u53f7/\u53d6\u8d1f\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u540e\u9762\u65e0\u5185\u5bb9");
                }
                if (!(i > 0 && (type = (last = eList.get(i - 1)).getType()) != 38 && type != 124 && type != 61 && type != 3361 || (type = (next = eList.get(i + 1)).getType()) != 3 && type != 7 && type != 4 && type != 4041 && type != 40410 && type != 9193)) {
                    _Negative _negative = new _Negative(next);
                    eList.remove(i);
                    eList.remove(i);
                    eList.add(i, _negative);
                    isDoLoop = true;
                    break;
                }
            }
            ++i;
        }
        if (isDoLoop) {
            ExpressionParser.parse_Negative(eList);
        }
        eList.trimToSize();
    }

    public static void parse_Not(ArrayList<Expression> eList) throws ExpressionException {
        boolean isDoLoop = false;
        int i = 0;
        while (i < eList.size()) {
            Expression expression = eList.get(i);
            if (expression.getType() == 33) {
                Expression last;
                if (i == eList.size() - 1) {
                    throw new ExpressionException("\u611f\u53f9\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u540e\u9762\u65e0\u5185\u5bb9");
                }
                if (i > 0 && (last = eList.get(i - 1)).getType() != 38 && last.getType() != 124) {
                    throw new ExpressionException("\u611f\u53f9\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u524d\u9762\u6709\u5185\u5bb9\u65f6\u4ec5\u652f\u6301&&\u3001||\u4e24\u79cd\u60c5\u51b5");
                }
                Expression nextExpression = eList.get(i + 1);
                _Not _not = new _Not(nextExpression);
                eList.remove(i);
                eList.remove(i);
                eList.add(i, _not);
                isDoLoop = true;
                break;
            }
            ++i;
        }
        if (isDoLoop) {
            ExpressionParser.parse_Not(eList);
        }
        eList.trimToSize();
    }

    public static void parse_DotDot(ArrayList<Expression> eList) throws ExpressionException {
        boolean isDoLoop = false;
        int i = 0;
        while (i < eList.size()) {
            Expression expression = eList.get(i);
            if (expression.getType() == 4646) {
                if (i == 0 || i == eList.size() - 1) {
                    throw new ExpressionException("\u53cc\u70b9\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u524d\u9762\u6216\u540e\u9762\u65e0\u5185\u5bb9");
                }
                Expression last = eList.get(i - 1);
                if (last.getType() != 3 && last.getType() != 4 && last.getType() != 40410 && last.getType() != 9193 && last.getType() != 4041) {
                    throw new ExpressionException("\u53cc\u70b9\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u524d\u540e\u5fc5\u987b\u6574\u578b\u6216\u53d8\u91cf\u3001\u65b9\u6cd5\u3001\u5c5e\u6027");
                }
                Expression next = eList.get(i + 1);
                if (next.getType() != 3 && next.getType() != 4 && next.getType() != 40410 && next.getType() != 9193 && next.getType() != 4041) {
                    throw new ExpressionException("\u53cc\u70b9\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u524d\u540e\u5fc5\u987b\u6574\u578b\u53d8\u91cf\u3001\u65b9\u6cd5\u3001\u5c5e\u6027");
                }
                _IntegerArray _te = new _IntegerArray(last, next);
                eList.remove(i);
                eList.remove(i);
                eList.remove(i - 1);
                eList.add(i - 1, _te);
                isDoLoop = true;
                break;
            }
            ++i;
        }
        if (isDoLoop) {
            ExpressionParser.parse_DotDot(eList);
        }
        eList.trimToSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean parse_Dot(ArrayList<Expression> eList, int i) throws ExpressionException {
        if (i == 0 || i == eList.size() - 1) {
            throw new ExpressionException("\u70b9\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u524d\u9762\u6216\u540e\u9762\u65e0\u5185\u5bb9");
        }
        Expression last = eList.get(i - 1);
        Expression nextExpression = eList.get(i + 1);
        if (last.getType() == 3) {
            if (nextExpression.getType() != 3) {
                throw new ExpressionException("\u70b9\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u6b63\u786e\u7684\u5c0f\u6570\u7c7b\u578b");
            }
            _Integer lastInteger = (_Integer)last;
            _Integer nextInteger = (_Integer)nextExpression;
            _Decimal _double = new _Decimal(String.valueOf(lastInteger.toString()) + "." + nextInteger.toString());
            eList.remove(i);
            eList.remove(i);
            eList.remove(i - 1);
            eList.add(i - 1, _double);
        } else if (last.getType() == 4) {
            if (nextExpression.getType() == 40410) {
                _Method _method = (_Method)nextExpression;
                _method.setObject(last);
                eList.remove(i);
                eList.remove(i - 1);
            } else if (nextExpression.getType() == 4) {
                _Variable _last = (_Variable)last;
                _Variable _next = (_Variable)nextExpression;
                _next.setValue(String.valueOf(_last.getValue()) + "." + _next.getValue());
                eList.remove(i);
                eList.remove(i - 1);
            } else {
                if (nextExpression.getType() != 6) throw new ExpressionException("\u70b9\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u6b63\u786e\u7684\u65b9\u6cd5F.\u7c7b\u578b");
                _Variable _last = (_Variable)last;
                _Class _next = (_Class)nextExpression;
                _next.setValue(String.valueOf(_last.getValue()) + "." + _next.getValue());
                eList.remove(i);
                eList.remove(i - 1);
            }
        } else {
            if (last.getType() != 40410 && last.getType() != 9193) throw new ExpressionException("\u70b9\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u6b63\u786e\u7684\u65b9\u6cd5\u7c7b\u578b\u6216\u5c0f\u6570\u7c7b\u578b");
            if (nextExpression.getType() != 40410) throw new ExpressionException("\u70b9\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u6b63\u786e\u7684\u65b9\u6cd5\u7c7b\u578b");
            _Method _method = (_Method)nextExpression;
            _method.setObject(last);
            eList.remove(i);
            eList.remove(i - 1);
        }
        eList.trimToSize();
        return true;
    }

    public static void parse_DotIndexable(ArrayList<Expression> eList) throws ExpressionException {
        boolean isDoLoop = false;
        int i = 0;
        while (i < eList.size()) {
            Expression expression = eList.get(i);
            int type = expression.getType();
            if (type == 46 || type == 9193) {
                switch (type) {
                    case 46: {
                        isDoLoop = ExpressionParser.parse_Dot(eList, i);
                        break;
                    }
                    case 9193: {
                        isDoLoop = ExpressionParser.parse_Indexable(eList, i);
                    }
                }
                if (isDoLoop) break;
            }
            ++i;
        }
        if (isDoLoop) {
            ExpressionParser.parse_DotIndexable(eList);
        }
        eList.trimToSize();
    }

    public static boolean parse_Indexable(ArrayList<Expression> eList, int i) throws ExpressionException {
        Expression expression = eList.get(i);
        _Indexable _indexKey = (_Indexable)expression;
        if (_indexKey.hasObject()) {
            return false;
        }
        if (i == 0) {
            throw new ExpressionException("\u89e3\u6790\u65b9\u62ec\u53f7\u65f6\uff0c\u524d\u9762\u6ca1\u6709\u8981\u6c42\u7684\u683c\u5f0f");
        }
        Expression last = eList.get(i - 1);
        if (last.getType() != 4041 && last.getType() != 4 && last.getType() != 1 && last.getType() != 40410 && last.getType() != 9193) {
            if (last.getType() == 3) {
                throw new ExpressionException("\u89e3\u6790\u65b9\u62ec\u53f7\u65f6\uff0c\u5982\u679c\u524d\u9762\u662f\u6574\u6570\u6570\u7ec4\u59821..3\uff0c\u8bf7\u4f7f\u7528\u62ec\u53f7(1..3)");
            }
            throw new ExpressionException("\u89e3\u6790\u65b9\u62ec\u53f7\u65f6\uff0c\u524d\u9762\u4e0d\u662f\u8981\u6c42\u7684\u683c\u5f0f");
        }
        _indexKey.setObject(last);
        _indexKey.parseBracketSquare();
        eList.remove(i - 1);
        return true;
    }

    public static void parse_BracketSquare(ArrayList<Expression> eList) throws ExpressionException {
        int num = 0;
        _Indexable _bracket = null;
        ListIterator<Expression> it = eList.listIterator();
        while (it.hasNext()) {
            Expression expression = it.next();
            if (expression.getType() == 91) {
                it.remove();
                if (++num == 1) {
                    _bracket = null;
                    _bracket = new _Indexable();
                    it.add(_bracket);
                }
                _bracket.addExpression(expression);
                continue;
            }
            if (expression.getType() == 93) {
                --num;
                it.remove();
                _bracket.addExpression(expression);
                continue;
            }
            if (num <= 0) continue;
            it.remove();
            _bracket.addExpression(expression);
        }
        if (num > 0) {
            throw new ExpressionException("\u65b9\u62ec\u53f7[]\u672a\u6210\u5bf9\u51fa\u73b0");
        }
        eList.trimToSize();
    }

    public static void parse_Bracket(ArrayList<Expression> eList) throws ExpressionException {
        int num = 0;
        _Bracket _bracket = null;
        ListIterator<Expression> it = eList.listIterator();
        while (it.hasNext()) {
            Expression expression = it.next();
            if (expression.getType() == 40) {
                it.remove();
                if (++num == 1) {
                    _bracket = null;
                    _bracket = new _Bracket();
                    it.add(_bracket);
                }
                _bracket.addExpression(expression);
                continue;
            }
            if (expression.getType() == 41) {
                --num;
                it.remove();
                _bracket.addExpression(expression);
                continue;
            }
            if (num <= 0) continue;
            it.remove();
            _bracket.addExpression(expression);
        }
        if (num > 0) {
            throw new ExpressionException("\u62ec\u53f7()\u672a\u6210\u5bf9\u51fa\u73b0");
        }
        boolean isDoLoop = true;
        block1: while (isDoLoop) {
            isDoLoop = false;
            int i = 0;
            while (i < eList.size()) {
                Expression last;
                Expression expression = eList.get(i);
                if (expression.getType() == 4041 && i != 0 && (last = eList.get(i - 1)).getType() == 4) {
                    _Variable _variable = (_Variable)last;
                    _Bracket bracket = (_Bracket)expression;
                    _Method _method = new _Method(_variable.getValue());
                    _method.parseBracketParamList(bracket);
                    eList.remove(i);
                    eList.remove(i - 1);
                    eList.add(i - 1, _method);
                    if (i >= 2 && eList.get(i - 2).getType() == 110101119) {
                        _method.setObject(eList.get(i - 2));
                        eList.remove(i - 1);
                        eList.remove(i - 2);
                        eList.add(i - 2, _method);
                    }
                    isDoLoop = true;
                    continue block1;
                }
                ++i;
            }
        }
        for (Expression expression : eList) {
            if (expression.getType() != 4041) continue;
            ((_Bracket)expression).parseBracket();
        }
        eList.trimToSize();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ArrayList<Expression> parse_Symbol(ArrayList<Object> list) throws ExpressionException {
        Expression expression;
        ArrayList<Expression> eList = new ArrayList<Expression>();
        for (Object obj : list) {
            if (!(obj instanceof String)) {
                expression = (Expression)obj;
                eList.add(expression);
                continue;
            }
            String str = ((String)obj).trim();
            if (Validates.isEmpty((String)str)) continue;
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                switch (c) {
                    case ' ': {
                        break;
                    }
                    case '.': {
                        eList.add(new _Dot());
                        break;
                    }
                    case '+': {
                        eList.add(new _Plus());
                        break;
                    }
                    case '-': {
                        eList.add(new _Minus());
                        break;
                    }
                    case '*': {
                        eList.add(new _Asterisk());
                        break;
                    }
                    case '/': {
                        eList.add(new _Slash());
                        break;
                    }
                    case '%': {
                        eList.add(new _Percent());
                        break;
                    }
                    case '!': {
                        eList.add(new _Exclamation());
                        break;
                    }
                    case '(': {
                        eList.add(new _OpenParenthesis());
                        break;
                    }
                    case ')': {
                        eList.add(new _CloseParenthesis());
                        break;
                    }
                    case '[': {
                        eList.add(new _OpenBracket());
                        break;
                    }
                    case ']': {
                        eList.add(new _CloseBracket());
                        break;
                    }
                    case ',': {
                        eList.add(new _Comma());
                        break;
                    }
                    case '=': {
                        eList.add(new _Equal());
                        break;
                    }
                    case '?': {
                        eList.add(new _Question());
                        break;
                    }
                    case ':': {
                        eList.add(new _Colon());
                        break;
                    }
                    case '&': {
                        eList.add(new _Ampersand());
                        break;
                    }
                    case '|': {
                        eList.add(new _VerticalBar());
                        break;
                    }
                    default: {
                        throw new ExpressionException("\u9047\u5230\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u4e32\u683c\u5f0f\uff1a{" + str + "}");
                    }
                }
                ++i;
            }
        }
        boolean hasDoLoop = true;
        block29: while (hasDoLoop) {
            hasDoLoop = false;
            int i = 0;
            while (i < eList.size()) {
                ExpressionPair pair;
                expression = eList.get(i);
                if (expression instanceof ExpressionPair && !(pair = (ExpressionPair)((Object)expression)).isPaired()) {
                    if (i == eList.size() - 1) {
                        throw new ExpressionException("\u9047\u5230\u9700\u914d\u5bf9\u7684\u5b57\u7b26\u4e32\u683c\u5f0f\uff1a{" + expression + "}\uff0c\u4f46\u4e0d\u652f\u6301");
                    }
                    pair.setPaired();
                    Expression next = eList.get(i + 1);
                    int type = expression.getType();
                    switch (type) {
                        case 38: {
                            if (next.getType() != 38) {
                                throw new ExpressionException("\u9047\u5230\u9700\u914d\u5bf9\u7684\u5b57\u7b26\u4e32\u683c\u5f0f\uff1a{" + expression + "}\uff0c\u4f46\u4e0d\u652f\u6301");
                            }
                            eList.remove(i + 1);
                            hasDoLoop = true;
                            continue block29;
                        }
                        case 124: {
                            if (next.getType() != 124) {
                                throw new ExpressionException("\u9047\u5230\u9700\u914d\u5bf9\u7684\u5b57\u7b26\u4e32\u683c\u5f0f\uff1a{" + expression + "}\uff0c\u4f46\u4e0d\u652f\u6301");
                            }
                            eList.remove(i + 1);
                            hasDoLoop = true;
                            continue block29;
                        }
                        case 61: {
                            if (next.getType() != 61) break;
                            eList.remove(i + 1);
                            hasDoLoop = true;
                            continue block29;
                        }
                        case 46: {
                            if (next.getType() != 46) break;
                            eList.remove(i);
                            eList.remove(i);
                            eList.add(i, new _DotDot());
                            hasDoLoop = true;
                            continue block29;
                        }
                        case 33: {
                            if (next.getType() != 61) break;
                            eList.remove(i);
                            eList.remove(i);
                            eList.add(i, new _Inequal());
                            hasDoLoop = true;
                            continue block29;
                        }
                    }
                }
                ++i;
            }
        }
        eList.trimToSize();
        return eList;
    }

    public static ArrayList<Object> parse_Variable(String expression) throws ExpressionException {
        ArrayList<Object> expList = new ArrayList<Object>();
        char lastChar = '\u0000';
        boolean isVariableString = false;
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < expression.length()) {
            char c = expression.charAt(i);
            if (!ExpressionParser.isVariableChar(c)) {
                if (ExpressionParser.isExpressionSeparator(c) && isVariableString) {
                    expList.add(ExpressionParser.buildNameValue(strb.toString()));
                    strb = null;
                    strb = new StringBuilder();
                    strb.append(c);
                    lastChar = c;
                    isVariableString = false;
                } else {
                    strb.append(c);
                    lastChar = c;
                }
            } else if (isVariableString) {
                strb.append(c);
                lastChar = c;
            } else if (lastChar == '\u0000') {
                isVariableString = true;
                strb.append(c);
                lastChar = c;
            } else {
                if (ExpressionParser.isExpressionSeparator(lastChar)) {
                    isVariableString = true;
                    if (strb.length() > 0) {
                        expList.add(strb.toString());
                    }
                    strb = null;
                    strb = new StringBuilder();
                }
                strb.append(c);
                lastChar = c;
            }
            ++i;
        }
        if (isVariableString) {
            expList.add(ExpressionParser.buildNameValue(strb.toString()));
        } else {
            expList.add(strb.toString());
        }
        strb = null;
        expList.trimToSize();
        return expList;
    }

    public static ArrayList<Object> parse_Numberic(String expression) throws ExpressionException {
        ArrayList<Object> expList = new ArrayList<Object>();
        char lastChar = '\u0000';
        boolean isInteger = false;
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < expression.length()) {
            char c = expression.charAt(i);
            if (!ExpressionParser.isValidChar(c)) {
                throw new ExpressionException("\u8868\u8fbe\u5f0f\u4e2d\u6709\u4e0d\u652f\u6301\u7684\u5b57\u7b26[" + c + "]");
            }
            if (c < '0' || c > '9') {
                if (ExpressionParser.isExpressionSeparator(c) && isInteger) {
                    expList.add(new _Integer(strb.toString()));
                    strb = null;
                    strb = new StringBuilder();
                    strb.append(c);
                    lastChar = c;
                    isInteger = false;
                } else {
                    strb.append(c);
                    lastChar = c;
                }
            } else if (isInteger) {
                strb.append(c);
                lastChar = c;
            } else if (lastChar == '\u0000') {
                isInteger = true;
                strb.append(c);
                lastChar = c;
            } else {
                if (ExpressionParser.isExpressionSeparator(lastChar)) {
                    isInteger = true;
                    if (strb.length() > 0) {
                        expList.add(strb.toString());
                    }
                    strb = null;
                    strb = new StringBuilder();
                }
                strb.append(c);
                lastChar = c;
            }
            ++i;
        }
        if (isInteger) {
            expList.add(new _Integer(strb.toString()));
        } else if (strb.length() > 0) {
            expList.add(strb.toString());
        }
        strb = null;
        expList.trimToSize();
        return expList;
    }

    public static ArrayList<Object> parse_Char(String expression) throws ExpressionException {
        ArrayList<Object> expList = new ArrayList<Object>();
        char lastChar = '\u0000';
        boolean isChar = false;
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < expression.length()) {
            char c = expression.charAt(i);
            if (c == ' ' && (lastChar == '\u0000' || lastChar == ' ')) {
                lastChar = c;
            } else if (c != '\'') {
                strb.append(c);
                lastChar = c;
            } else {
                if (!isChar) {
                    isChar = true;
                    if (strb.length() > 0) {
                        expList.add(strb.toString());
                        strb = null;
                        strb = new StringBuilder();
                        strb.append(c);
                    }
                } else if (lastChar == '\\') {
                    strb.append(c);
                } else {
                    strb.append(c);
                    expList.add(new _Char(strb.toString()));
                    strb = null;
                    strb = new StringBuilder();
                    isChar = false;
                }
                lastChar = c;
            }
            ++i;
        }
        if (isChar) {
            throw new ExpressionException("\u5b57\u7b26\u7ed3\u675f\u7b26\u4e0d\u5339\u914d");
        }
        if (strb.length() > 0) {
            expList.add(strb.toString());
            strb = null;
        }
        expList.trimToSize();
        return expList;
    }

    public static ArrayList<Object> parse_String(String expression) throws ExpressionException {
        ArrayList<Object> expList = new ArrayList<Object>();
        int lastChar = 0;
        boolean isString = false;
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < expression.length()) {
            char c = expression.charAt(i);
            if (c != '\"') {
                if (isString || c != ' ' || lastChar != 0 && lastChar != 32) {
                    strb.append(c);
                }
                lastChar = c;
            } else {
                if (!isString) {
                    isString = true;
                    if (strb.length() > 0) {
                        expList.add(strb.toString());
                    }
                    strb = null;
                    strb = new StringBuilder();
                    strb.append(c);
                } else if (lastChar == 92) {
                    strb.append(c);
                } else {
                    strb.append(c);
                    expList.add(new _String(strb.toString()));
                    strb = null;
                    strb = new StringBuilder();
                    isString = false;
                }
                lastChar = c;
            }
            ++i;
        }
        if (isString) {
            throw new ExpressionException("\u5b57\u7b26\u4e32\u7ed3\u675f\u7b26\u4e0d\u5339\u914d");
        }
        if (strb.length() > 0) {
            expList.add(strb.toString());
            strb = null;
        }
        expList.trimToSize();
        return expList;
    }

    public static boolean isExpressionSeparator(char c) {
        return c == ' ' || c == ',' || c == '(' || c == ')' || c == '[' || c == ']' || c == '.' || c == '!' || c == '-' || c == '+' || c == '*' || c == '/' || c == '%' || c == '&' || c == '|' || c == '?' || c == ':' || c == '=';
    }

    public static boolean isVariableChar(char c) {
        return c == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isValidChar(char c) {
        if (ExpressionParser.isVariableChar(c)) {
            return true;
        }
        if (ExpressionParser.isExpressionSeparator(c)) {
            return true;
        }
        return c == '\"' || c == '\'';
    }

    private static Expression buildNameValue(String value) {
        if ("true".equals(value) || "false".equals(value)) {
            return new _Boolean(Boolean.parseBoolean(value));
        }
        if ("null".equals(value)) {
            return new _Null();
        }
        if ("gt".equals(value)) {
            return new _Gt();
        }
        if ("gte".equals(value)) {
            return new _Gte();
        }
        if ("lt".equals(value)) {
            return new _Lt();
        }
        if ("lte".equals(value)) {
            return new _Lte();
        }
        if ("class".equals(value)) {
            return new _Class(value);
        }
        if ("new".equals(value)) {
            return new _New();
        }
        return new _Variable(value);
    }

    public static String replaceBlank(String expression) {
        StringBuilder strb = new StringBuilder();
        boolean isString = false;
        int lastChar = 0;
        int i = 0;
        while (i < expression.length()) {
            char c = expression.charAt(i);
            if (c != '\"') {
                if (isString || c != ' ' || lastChar != 0 && lastChar != 34 && !ExpressionParser.isExpressionSeparator(c)) {
                    strb.append(c);
                }
                lastChar = c;
            } else if (!isString) {
                isString = true;
                strb.append(c);
                lastChar = c;
            } else {
                if (lastChar != 92) {
                    isString = false;
                }
                strb.append(c);
                lastChar = c;
            }
            ++i;
        }
        return strb.toString();
    }

    public static boolean compare(Object privous, Object next, Expression expression) throws ExpressionException {
        String typeDesc = null;
        switch (expression.getType()) {
            case 110: {
                typeDesc = "\u5927\u4e8e";
                break;
            }
            case 120: {
                typeDesc = "\u5927\u4e8e\u7b49\u4e8e";
                break;
            }
            case 130: {
                typeDesc = "\u5c0f\u4e8e";
                break;
            }
            case 140: {
                typeDesc = "\u5c0f\u4e8e\u7b49\u4e8e";
                break;
            }
            default: {
                throw new ExpressionException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f");
            }
        }
        if (privous == null || next == null) {
            return false;
        }
        if (privous instanceof String || next instanceof String) {
            String str2;
            String str1 = String.valueOf(privous);
            return str1.compareTo(str2 = String.valueOf(next)) > 0;
        }
        if (!Types.isNumber((Object)privous) && !Types.isChar((Object)privous) || !Types.isNumber((Object)next) && !Types.isChar((Object)next)) {
            throw new ExpressionException(String.valueOf(typeDesc) + "\u8868\u8fbe\u5f0f{" + expression + "}\uff0c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u51fa\u73b0\u503c\u4e0d\u662f\u6570\u503c\u578b\u548c\u5b57\u7b26\u4e32");
        }
        if (Types.isInteger((Object)privous)) {
            long num1 = ((Number)privous).longValue();
            if (Types.isInteger((Object)next)) {
                long num2 = ((Number)next).longValue();
                switch (expression.getType()) {
                    case 110: {
                        return num1 > num2;
                    }
                    case 120: {
                        return num1 >= num2;
                    }
                    case 130: {
                        return num1 < num2;
                    }
                    case 140: {
                        return num1 <= num2;
                    }
                }
            } else if (Types.isDecimal((Object)next)) {
                double num2 = ((Number)next).doubleValue();
                switch (expression.getType()) {
                    case 110: {
                        return (double)num1 > num2;
                    }
                    case 120: {
                        return (double)num1 >= num2;
                    }
                    case 130: {
                        return (double)num1 < num2;
                    }
                    case 140: {
                        return (double)num1 <= num2;
                    }
                }
            } else {
                char num2 = ((Character)next).charValue();
                switch (expression.getType()) {
                    case 110: {
                        return num1 > (long)num2;
                    }
                    case 120: {
                        return num1 >= (long)num2;
                    }
                    case 130: {
                        return num1 < (long)num2;
                    }
                    case 140: {
                        return num1 <= (long)num2;
                    }
                }
            }
        } else if (Types.isDecimal((Object)privous)) {
            double num1 = ((Number)privous).doubleValue();
            if (Types.isInteger((Object)next)) {
                long num2 = ((Number)next).longValue();
                switch (expression.getType()) {
                    case 110: {
                        return num1 > (double)num2;
                    }
                    case 120: {
                        return num1 >= (double)num2;
                    }
                    case 130: {
                        return num1 < (double)num2;
                    }
                    case 140: {
                        return num1 <= (double)num2;
                    }
                }
            } else if (Types.isDecimal((Object)next)) {
                double num2 = ((Number)next).doubleValue();
                switch (expression.getType()) {
                    case 110: {
                        return num1 > num2;
                    }
                    case 120: {
                        return num1 >= num2;
                    }
                    case 130: {
                        return num1 < num2;
                    }
                    case 140: {
                        return num1 <= num2;
                    }
                }
            } else {
                char num2 = ((Character)next).charValue();
                switch (expression.getType()) {
                    case 110: {
                        return num1 > (double)num2;
                    }
                    case 120: {
                        return num1 >= (double)num2;
                    }
                    case 130: {
                        return num1 < (double)num2;
                    }
                    case 140: {
                        return num1 <= (double)num2;
                    }
                }
            }
        } else {
            char num1 = ((Character)privous).charValue();
            if (Types.isInteger((Object)next)) {
                long num2 = ((Number)next).longValue();
                switch (expression.getType()) {
                    case 110: {
                        return (long)num1 > num2;
                    }
                    case 120: {
                        return (long)num1 >= num2;
                    }
                    case 130: {
                        return (long)num1 < num2;
                    }
                    case 140: {
                        return (long)num1 <= num2;
                    }
                }
            } else if (Types.isDecimal((Object)next)) {
                double num2 = ((Number)next).doubleValue();
                switch (expression.getType()) {
                    case 110: {
                        return (double)num1 > num2;
                    }
                    case 120: {
                        return (double)num1 >= num2;
                    }
                    case 130: {
                        return (double)num1 < num2;
                    }
                    case 140: {
                        return (double)num1 <= num2;
                    }
                }
            } else {
                char num2 = ((Character)next).charValue();
                switch (expression.getType()) {
                    case 110: {
                        return num1 > num2;
                    }
                    case 120: {
                        return num1 >= num2;
                    }
                    case 130: {
                        return num1 < num2;
                    }
                    case 140: {
                        return num1 <= num2;
                    }
                }
            }
        }
        throw new ExpressionException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f");
    }
}

