/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.codes;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Hexs;

public class MD5
implements CodeConstants {
    public static String encodeUTF8(String src) {
        return MD5.encode(src, _UTF_8_C_);
    }

    public static String encode(String src, String encoding) {
        byte[] destBytes = MD5.encodeByte(src, encoding);
        return Hexs.toHexString(destBytes);
    }

    public static String encode(String src, Charset charset) {
        byte[] destBytes = MD5.encodeByte(src, charset);
        return Hexs.toHexString(destBytes);
    }

    public static String encode(byte[] src) {
        byte[] destBytes = MD5.encodeByte(src);
        return Hexs.toHexString(destBytes);
    }

    public static byte[] encodeByte(String src, String encoding) {
        Asserts.notNull(src, "src");
        Asserts.notNull(encoding, "encoding");
        try {
            return MD5.encodeByte(src.getBytes(encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Asserts.exception("\u975e\u6cd5\u7684\u7f16\u7801");
        }
    }

    public static byte[] encodeByte(String src, Charset charset) {
        Asserts.notNull(src, "src");
        Asserts.notNull(charset, "charset");
        return MD5.encodeByte(src.getBytes(charset));
    }

    public static byte[] encodeByte(byte[] src) {
        Asserts.notNull(src, "src");
        return MD5.getInstance().digest(src);
    }

    public static MessageDigest getInstance() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Asserts.exception("JDK\u4e0d\u652f\u6301[MD5]\u7b97\u6cd5");
        }
    }
}

