/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.util.regex.Pattern;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.RegexpConstants;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Validatex"})
public class Validatex
implements RegexpConstants {
    public static boolean isRegexp(String regexp, String value, boolean allowEmpty) {
        if (Validates.isEmpty(value)) {
            return allowEmpty;
        }
        regexp = Strings.trim(regexp, "/", "/");
        return Pattern.matches(regexp, value);
    }

    public static boolean isBoolean(String value, boolean allowEmpty) {
        if (Validates.isEmpty(value)) {
            return allowEmpty;
        }
        return "true".equals(value) || "false".equals(value);
    }

    public static boolean isNumeric(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^\\d+$", value, allowEmpty);
    }

    public static boolean isInteger(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^(0|[\\+\\-]?[1-9]\\d*)$", value, allowEmpty);
    }

    public static boolean isIntegerPositive(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[1-9]\\d*$", value, allowEmpty);
    }

    public static boolean isIntegerNegative(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^\\-[1-9]\\d*$", value, allowEmpty);
    }

    public static boolean isIntegerNonnegative(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^(0|[1-9]\\d*)$", value, allowEmpty);
    }

    public static boolean isIntegerNonpositive(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^(0|\\-[1-9]\\d*)$", value, allowEmpty);
    }

    public static boolean isAlphabetic(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[A-Za-z]+$", value, allowEmpty);
    }

    public static boolean isAlphabeticUppercase(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[A-Z]+$", value, allowEmpty);
    }

    public static boolean isAlphabeticLowercase(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[a-z]+$", value, allowEmpty);
    }

    public static boolean isAlphaNumeric(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[A-Za-z0-9]+$", value, allowEmpty);
    }

    public static boolean isAlphaNumericPA(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[A-Za-z][A-Za-z0-9]*$", value, allowEmpty);
    }

    public static boolean isAlphaNumericUl(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[A-Za-z0-9_]+$", value, allowEmpty);
    }

    public static boolean isAlphaNumericDot(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[A-Za-z0-9\\.]+$", value, allowEmpty);
    }

    public static boolean isAlphaNumericUrl(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[A-Za-z0-9\\.\\-_~]+$", value, allowEmpty);
    }

    public static boolean isAlphaNumericUlPA(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[A-Za-z_][A-Za-z0-9_]*$", value, allowEmpty);
    }

    public static boolean isAlphaNumericUlDlPA(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[A-Za-z_\\$][A-Za-z0-9_\\$]*$", value, allowEmpty);
    }

    public static boolean isAlphaUpperNumeric(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[A-Z0-9]+$", value, allowEmpty);
    }

    public static boolean isAlphaLowerNumeric(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[a-z0-9]+$", value, allowEmpty);
    }

    public static boolean isFloat(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^(0|[\\+\\-]?[1-9]\\d*)(\\.\\d+)?$", value, allowEmpty);
    }

    public static boolean isAmount2R(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^(0|[\\+\\-]?[1-9]\\d*)(\\.\\d{1,2})?$", value, allowEmpty);
    }

    public static boolean isEmail(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^([\\w-_]+(?:\\.[\\w-_]+)*)@((?:[a-z0-9]+(?:-[a-zA-Z0-9]+)*)+\\.[a-z]{2,6})$", value, allowEmpty);
    }

    public static boolean isIP(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^((?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])\\.){3}(?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])$", value, allowEmpty);
    }

    public static boolean isMacAddress(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}$", value, allowEmpty);
    }

    public static boolean isMobile(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^((\\+86)|(86)|)?(13[0-9]|14[5|7|9]|15[0|1|2|3|5|6|7|8|9]|17[0|1|3|5|6|7|8]|18[0-9])\\d{8}$", value, allowEmpty);
    }

    public static boolean isMobile11(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^(13[0-9]|14[5|7|9]|15[0|1|2|3|5|6|7|8|9]|17[0|1|3|5|6|7|8]|18[0-9])\\d{8}$", value, allowEmpty);
    }

    public static boolean isDate(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)$", value, allowEmpty);
    }

    public static boolean isTime(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9])$", value, allowEmpty);
    }

    public static boolean isDateTime(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))\\s(([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9]))$", value, allowEmpty);
    }

    public static boolean isIdcard(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^(\\d{6})((((19|20)[0-9]{2})(((0[13578]|1[02])(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))(\\d{3}[0-9xX*])$", value, allowEmpty);
    }

    public static boolean isPostalCode(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[1-9]\\d{5}$", value, allowEmpty);
    }

    public static boolean isUserCode(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^[a-zA-Z0-9\\u4e00-\\u9fa5][._\\-`~!@#$%a-zA-Z0-9\\u4e00-\\u9fa5]{1,15}$", value, allowEmpty);
    }

    public static boolean isUserPass(String value, boolean allowEmpty) {
        return Validatex.isRegexp("^(?:(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9])|(?=.*[A-Z])(?=.*[a-z])(?=.*[._\\-`~!@#$%])|(?=.*[A-Z])(?=.*[0-9])(?=.*[._\\-`~!@#$%])|(?=.*[a-z])(?=.*[0-9])(?=.*[._\\-`~!@#$%])).{6,16}$", value, allowEmpty);
    }
}

