/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.seqs.Sequence;

@AnAlias(value={"Threads"})
public class Threads {
    public static StackTraceElement getInvoker() {
        StackTraceElement[] elems = Thread.currentThread().getStackTrace();
        return elems[3];
    }

    public static String getInvokerString() {
        StackTraceElement[] elems = Thread.currentThread().getStackTrace();
        StackTraceElement elem = elems[3];
        return "[" + elem.getClassName() + "]" + "[" + elem.getMethodName() + "]" + "[\u7b2c" + elem.getLineNumber() + "\u884c]";
    }

    public static String getInvokerAbbr() {
        StackTraceElement[] elems = Thread.currentThread().getStackTrace();
        StackTraceElement elem = elems[3];
        String className = Strings.removeLeftByLast(elem.getClassName(), ".");
        return "[" + className + "." + elem.getMethodName() + "(\u7b2c" + elem.getLineNumber() + "\u884c)" + "]";
    }

    public static Thread newThread(Runnable runnable) {
        return new Thread(runnable);
    }

    public static Thread newThread(Runnable runnable, String name) {
        return new Thread(runnable, name);
    }

    public static Thread newThread(Runnable runnable, String name, int sequence) {
        return new Thread(runnable, String.valueOf(name) + "-" + sequence);
    }

    public static Thread newThread(Runnable runnable, String name, Sequence sequence) {
        return new Thread(runnable, String.valueOf(name) + "-" + sequence.next());
    }

    public static Thread newThread(ThreadGroup group, Runnable runnable, int sequence) {
        return new Thread(group, runnable, String.valueOf(group.getName()) + "-" + sequence);
    }

    public static Thread newThread(ThreadGroup group, Runnable runnable, Sequence sequence) {
        return new Thread(group, runnable, String.valueOf(group.getName()) + "-" + sequence.next());
    }

    public static void sleepIgnoreException(int millis) {
        if (millis <= 0) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void closeIgnoreException(AutoCloseable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Throwable throwable) {}
    }
}

