/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.text.DecimalFormat;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.EnumConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Amounts"})
public class Amounts
implements EnumConstants {
    public static String toYuan(String fen) {
        Asserts.asInteger(fen);
        return Amounts.toYuan(Long.parseLong(fen));
    }

    public static String toYuan(long fen) {
        int radixLen = 2;
        int divisor = 100;
        double result = (double)fen / (double)divisor;
        StringBuilder radix = new StringBuilder("#");
        radix.append(".");
        int i = 0;
        while (i < radixLen) {
            radix.append("#");
            ++i;
        }
        DecimalFormat df = new DecimalFormat(radix.toString());
        return df.format(result);
    }

    public static String toYuanMustRadix(String fen) {
        Asserts.asInteger(fen);
        return Amounts.toYuanMustRadix(Long.parseLong(fen));
    }

    public static String toYuanMustRadix(long fen) {
        String ret;
        block4: {
            int ind;
            int radixLen;
            block3: {
                radixLen = 2;
                int divisor = 100;
                double result = (double)fen / (double)divisor;
                StringBuilder radix = new StringBuilder("#");
                radix.append(".");
                int i = 0;
                while (i < radixLen) {
                    radix.append("#");
                    ++i;
                }
                DecimalFormat df = new DecimalFormat(radix.toString());
                ret = df.format(result);
                ind = ret.indexOf(46);
                if (ind != -1) break block3;
                ret = String.valueOf(ret) + ".";
                int i2 = 0;
                while (i2 < radixLen) {
                    ret = String.valueOf(ret) + "0";
                    ++i2;
                }
                break block4;
            }
            if (ind <= ret.length() - radixLen - 1) break block4;
            int zeroNum = ind - (ret.length() - radixLen - 1);
            int i = 0;
            while (i < zeroNum) {
                ret = String.valueOf(ret) + "0";
                ++i;
            }
        }
        return ret;
    }

    public static int toFen(String yuan, int defaultValue) {
        int index;
        if (yuan == null) {
            return defaultValue;
        }
        if (!Validates.isAmount2R(yuan)) {
            return defaultValue;
        }
        boolean isNegative = false;
        if (yuan.startsWith("-")) {
            isNegative = true;
            yuan = yuan.substring(1);
        }
        if ((index = yuan.indexOf(46)) == -1) {
            int value = Integer.parseInt(yuan) * 100;
            return isNegative ? -value : value;
        }
        int integer = Integer.parseInt(yuan.substring(0, index)) * 100;
        String radixString = yuan.substring(index + 1);
        if (radixString.length() == 0) {
            return isNegative ? -integer : integer;
        }
        if (radixString.length() == 1) {
            int radix = Integer.parseInt(radixString);
            int value = integer + radix * 10;
            return isNegative ? -value : value;
        }
        int radix = Integer.parseInt(radixString);
        int value = integer + radix;
        return isNegative ? -value : value;
    }

    public static long toFen(String yuan, long defaultValue) {
        int index;
        if (yuan == null) {
            return defaultValue;
        }
        if (!Validates.isAmount2R(yuan)) {
            return defaultValue;
        }
        boolean isNegative = false;
        if (yuan.startsWith("-")) {
            isNegative = true;
            yuan = yuan.substring(1);
        }
        if ((index = yuan.indexOf(46)) == -1) {
            long value = Long.parseLong(yuan) * 100L;
            return isNegative ? -value : value;
        }
        long integer = Long.parseLong(yuan.substring(0, index)) * 100L;
        String radixString = yuan.substring(index + 1);
        if (radixString.length() == 0) {
            return isNegative ? -integer : integer;
        }
        if (radixString.length() == 1) {
            long radix = Long.parseLong(radixString);
            long value = integer + radix * 10L;
            return isNegative ? -value : value;
        }
        long radix = Long.parseLong(radixString);
        long value = integer + radix;
        return isNegative ? -value : value;
    }

    public static String toChinese(int value) {
        String r;
        Integer in = new Integer(value);
        double src = in.doubleValue();
        StringBuilder sb = new StringBuilder();
        DecimalFormat df = new DecimalFormat("0.00");
        String srcText = df.format(src /= 100.0);
        String numText = srcText.substring(0, srcText.length() - 3);
        String decText = srcText.substring(srcText.length() - 2);
        int numlen = numText.length();
        int k = 0;
        while (k < numlen) {
            sb.append(_RMB_NUM_[Integer.parseInt(String.valueOf(srcText.charAt(k)))]);
            sb.append(_RMB_UNIT_[numlen - k - 1]);
            ++k;
        }
        if ("00".equals(decText)) {
            sb.append("\u6574");
        } else {
            sb.append(_RMB_NUM_[Integer.parseInt(String.valueOf(decText.charAt(0)))]);
            sb.append(_RMB_DEC_[0]);
            sb.append(_RMB_NUM_[Integer.parseInt(String.valueOf(decText.charAt(1)))]);
            sb.append(_RMB_DEC_[1]);
        }
        String result = sb.toString();
        result = result.replace("\u96f6\u5206", "");
        result = result.replace("\u96f6\u89d2", "\u96f6");
        result = result.replace("\u96f6\u4edf", "\u96f6");
        result = result.replace("\u96f6\u4f70", "\u96f6");
        result = result.replace("\u96f6\u62fe", "\u96f6");
        result = result.replace("\u96f6\u5706", "\u5706");
        while (!(r = result.replace("\u96f6\u96f6", "\u96f6")).equals(result)) {
            result = r;
        }
        result = result.replace("\u96f6\u5706", "\u5706");
        result = result.replace("\u96f6\u4e07", "\u4e07");
        result = result.replace("\u96f6\u4ebf", "\u4ebf");
        result = result.replace("\u4ebf\u4e07", "\u4ebf");
        if (result.startsWith("\u5706")) {
            result = "\u96f6" + result;
        }
        return result;
    }

    public static String toDiscount(String price, String priceNew) {
        long priceLong = Amounts.toFen(price, 0);
        long priceNewLong = Amounts.toFen(priceNew, 0);
        return Amounts.toDiscount(priceLong, priceNewLong);
    }

    public static String toDiscount(long price, long priceNew) {
        long priceSave = price - priceNew;
        if (priceSave == 0L) {
            return "10";
        }
        return Amounts.toYuan(priceNew * 1000L / price);
    }
}

