/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging.logger;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.logger.FileLogger;
import org.zhiqim.kernel.util.Files;

public class FileSizeLogger
extends FileLogger {
    private Object lock = new Object();

    @Override
    public void logger(Log log, int level, String message, Throwable throwable) {
        if (level < super.getLevelMin() || level > super.getLevelMax()) {
            return;
        }
        if (super.getFileSize() >= (long)(super.getFileMaxSize() * 1024 * 1024)) {
            this.doConvertWriter(false);
        }
        this.print(level, message, throwable);
    }

    @Override
    public void setFilePath(String filePath) {
        super.setFilePath(filePath);
        this.doConvertWriter(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConvertWriter(boolean first) {
        Object object = this.lock;
        synchronized (object) {
            if (first) {
                if (super.getWriter() != null) {
                    return;
                }
                if (super.getFileSize() >= (long)super.getFileMaxSize()) {
                    Files.removeMaxFileAndRenameFile(this.fileDir, this.fileName, this.fileMaxNum, true);
                }
                super.createWriter();
            } else {
                if (super.getFileSize() < (long)super.getFileMaxSize()) {
                    return;
                }
                super.closeWriter();
                Files.removeMaxFileAndRenameFile(this.fileDir, this.fileName, this.fileMaxNum, true);
                super.createWriter();
            }
        }
    }
}

