/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.control;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.zhiqim.kernel.control.ThreadLock;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Asserts;

public class Queue<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ThreadLock lock = new ThreadLock();
    private final LinkedList<E> list = new LinkedList();

    public void post(E e) {
        this.post(e, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(E e, boolean priority) {
        if (e == null) {
            return;
        }
        LinkedList<E> linkedList = this.list;
        synchronized (linkedList) {
            if (priority) {
                this.list.addFirst(e);
            } else {
                this.list.add(e);
            }
        }
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E accept(int timeout) {
        LinkedList<E> linkedList = this.list;
        synchronized (linkedList) {
            if (!this.list.isEmpty()) {
                return this.list.removeFirst();
            }
        }
        this.lock.lock(timeout);
        linkedList = this.list;
        synchronized (linkedList) {
            block8: {
                if (!this.list.isEmpty()) break block8;
                return null;
            }
            return this.list.removeFirst();
        }
    }

    public boolean contains(E e) {
        return this.list.contains(e);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<E> linkedList = this.list;
        synchronized (linkedList) {
            this.list.clear();
        }
    }

    public int size() {
        return this.list.size();
    }

    public PageResult<E> list(int pageNo, int pageSize) {
        Asserts.as((String)(pageNo > 0 && pageSize > 0 ? null : "\u9875\u7801\u5fc5\u987b\u5927\u4e8e0"));
        int formIndex = (pageNo - 1) * pageSize;
        int toIndex = pageNo * pageSize;
        ArrayList<E> li = new ArrayList<E>(pageSize);
        int i = formIndex;
        while (i < toIndex) {
            if (i >= this.list.size()) break;
            try {
                li.add(this.list.get(i));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            ++i;
        }
        return PageBuilder.newResult(this.list.size(), pageNo, pageSize, Collections.unmodifiableList(li));
    }
}

