/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.Service;
import org.zhiqim.kernel.ZhiqimClasspath;
import org.zhiqim.kernel.ZhiqimCommand;
import org.zhiqim.kernel.ZhiqimHook;
import org.zhiqim.kernel.ZhiqimMonitor;
import org.zhiqim.kernel.annotation.AnGlobal;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.config.Config;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.config.Item;
import org.zhiqim.kernel.constants.ZhiqimConstants;
import org.zhiqim.kernel.control.Filter;
import org.zhiqim.kernel.control.FilterEndsWith;
import org.zhiqim.kernel.control.FilterHandler;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Annotations;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Jars;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Systems;
import org.zhiqim.kernel.util.Validates;

public final class Zhiqim
implements ZhiqimConstants {
    private static final Log log = LogFactory.getLog(Zhiqim.class);

    private Zhiqim() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Zhiqim.startup(args);
        } else if (args.length == 1) {
            if ("-s".equals(args[0])) {
                Zhiqim.startup(args);
            } else {
                ZhiqimCommand.command(args);
            }
        } else {
            System.out.println("\u4e0d\u652f\u6301\u7684\u53c2\u6570\uff0c\u8bf7\u4f7f\u7528-h\u67e5\u770b\u652f\u6301\u7684\u53c2\u6570");
        }
    }

    private static void startup(String[] args) {
        if (!Zhiqim.chkJavaVersion()) {
            System.exit(1);
            return;
        }
        if (!Zhiqim.loadConfig()) {
            System.exit(1);
            return;
        }
        if (!Zhiqim.registerMonitor()) {
            System.exit(1);
            return;
        }
        log.info((Object)"\u7cfb\u7edf[%s]-\u7248\u672c[%s]\u521d\u59cb\u5316\u5f00\u59cb...\r\n", Global.getName(), Global.getVersion());
        if (!Zhiqim.loadClasspath(args)) {
            System.exit(1);
            return;
        }
        if (!Zhiqim.loadClassAliasName()) {
            System.exit(1);
            return;
        }
        if (!Zhiqim.createService()) {
            System.exit(1);
            return;
        }
        Runtime.getRuntime().addShutdownHook(new ZhiqimHook());
        log.info((Object)"\u7cfb\u7edf[%s]-\u7248\u672c[%s]\u521d\u59cb\u5316\u5b8c\u6210!!!\r\n", Global.getName(), Global.getVersion());
    }

    public static boolean chkJavaVersion() {
        String vers = Systems.getJavaVersion();
        if (vers.compareTo("1.7") < 0) {
            System.out.println("JDK\u7248\u672c\u4e0d\u80fd\u4f4e\u4e8e[1.7]");
            System.out.println("java.vm.info:  " + Systems.getVmInfo());
            System.out.println("java.vm.name:  " + Systems.getVmName());
            System.out.println("java.vm.version:  " + Systems.getVmVersion());
            return false;
        }
        return true;
    }

    private static boolean loadConfig() {
        Config config;
        String path;
        block12: {
            path = null;
            if (Files.exists("./conf/zhiqim.xml")) {
                path = "./conf/zhiqim.xml";
            } else if (Files.exists("./conf/zhiqim.ini")) {
                path = "./conf/zhiqim.ini";
            }
            if (path == null) {
                log.error((Object)"\u914d\u7f6e\u6587\u4ef6[%s]\u548c[%s]\u90fd\u4e0d\u5b58\u5728\uff0c\u8bf7\u6309\u624b\u518c\u914d\u7f6e\u76ee\u5f55\u7ed3\u6784", "./conf/zhiqim.xml", "./conf/zhiqim.ini");
                return false;
            }
            config = new Config("zhiqim", path);
            try {
                config.load();
                if (config.hasGroup("boot") && config.hasItem("boot", "name") && config.hasItem("boot", "version") && config.hasItem("boot", "port")) break block12;
                log.error("\u914d\u7f6e\u6587\u4ef6[boot]\u7ec4\u4e2dname,version,port\u5fc5\u987b\u7684\uff0c\u8bf7\u914d\u7f6e\u597d\u518d\u542f\u52a8");
                return false;
            }
            catch (Exception e) {
                log.error((Object)"\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6[%s]\u65f6\u5f02\u5e38", e, path);
                return false;
            }
        }
        String result = Global.addConfig(config);
        if (result != null) {
            log.error((Object)"\u6839\u914d\u7f6e\u6587\u4ef6[%s]\u5728\u8fd9\u91cc[%s]\u6709\u914d\u7f6e\u9519\u8bef", path, result);
            return false;
        }
        if (config.hasGroup("config")) {
            Collection<Item> itemList = config.getItemList("config");
            for (Item item : itemList) {
                try {
                    Config conf = new Config(item.getKey(), item.getString()).load();
                    String result2 = Global.addConfig(conf);
                    if (result2 == null) continue;
                    log.error((Object)"\u914d\u7f6e\u6587\u4ef6[%s]\u5b58\u5728\u548c\u522b\u7684\u914d\u7f6e\u6587\u4ef6\u76f8\u540c\u7684\u914d\u7f6e\u7ec4[%s]", item.getString(), result2);
                    return false;
                }
                catch (Exception e) {
                    log.error((Object)"\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6[%s]\u65f6\u5f02\u5e38", e, item.getString());
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean registerMonitor() {
        int port = Global.getPort();
        if (port < 1 || port > 65535) {
            log.error("\u914d\u7f6e\u6587\u4ef6[boot.port]\u4e0d\u662f\u6b63\u786e\u7684\u7aef\u53e3");
            return false;
        }
        ZhiqimMonitor monitor = new ZhiqimMonitor(port);
        return monitor.open();
    }

    private static boolean loadClasspath(String[] args) {
        if (args.length < 1) {
            return true;
        }
        try {
            ZhiqimClasspath _classpath = new ZhiqimClasspath();
            _classpath.initClasspath(Global.getString("boot", "libext"));
            Global.add(ZhiqimClasspath.class, _classpath);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"\u521d\u59cb\u5316\u7c7b\u52a0\u8f7d\u8def\u5f84\u65f6\u5f02\u5e38", e, new Object[0]);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean createService() {
        if (!Global.hasGroup("service")) {
            return true;
        }
        try {
            Group group = Global.getGroup("service");
            Iterator<Item> iterator = group.list().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                Item item = iterator.next();
                String className = item.getString();
                Object obj = Global.newInstance(className);
                if (obj == null) {
                    log.fatal((Object)"\u670d\u52a1[%s]\u672a\u627e\u5230\u8be5\u7c7b", className);
                    return false;
                }
                if (!(obj instanceof Service)) {
                    log.fatal((Object)"\u670d\u52a1[%s]\u672a\u5b9e\u73b0Service\u63a5\u53e3\uff0c\u9000\u51fa\u5de5\u7a0b", className);
                    return false;
                }
                Service service = (Service)obj;
                service.setId(item.getKey());
                if (!service.create()) {
                    log.fatal((Object)"\u670d\u52a1[%s]\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9000\u51fa\u5de5\u7a0b", className);
                    return false;
                }
                Global.addService(service);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u521d\u59cb\u5316\u521b\u5efa\u670d\u52a1\u65f6\u5f02\u5e38\uff0c\u9000\u51fa\u5de5\u7a0b", e, new Object[0]);
            return false;
        }
    }

    private static boolean loadClassAliasName() {
        String path;
        Iterator<String> it;
        List<String> patternList;
        List<String> pathList = Lists.toList(Systems.getClassPaths());
        String include = Global.getString("boot", "include");
        String exclude = Global.getString("boot", "exclude");
        if (Validates.isNotEmptyBlank(include)) {
            patternList = Lists.toStringList(Files.toLinuxPath(include));
            it = pathList.iterator();
            block0: while (it.hasNext()) {
                path = Files.toLinuxPath(it.next());
                for (String pattern : patternList) {
                    if (Validates.isMatch(path, pattern)) continue block0;
                }
                it.remove();
            }
        }
        if (Validates.isNotEmptyBlank(exclude)) {
            patternList = Lists.toStringList(Files.toLinuxPath(exclude));
            it = pathList.iterator();
            block2: while (it.hasNext()) {
                path = Files.toLinuxPath(it.next());
                for (String pattern : patternList) {
                    if (!Validates.isMatch(path, pattern)) continue;
                    it.remove();
                    continue block2;
                }
            }
        }
        return Zhiqim.loadClassAliasName(pathList);
    }

    public static boolean loadClassAliasName(List<String> pathList) {
        Filter filter = new FilterEndsWith().param(".class");
        FilterHandler handler = new FilterHandler(){

            @Override
            public boolean handle(Object obj) throws Exception {
                JarEntry jarEntry;
                String className;
                File classFile;
                File classPath;
                String className2;
                Object[] objs = (Object[])obj;
                return !(objs[0] instanceof File ? !Zhiqim.setClassAlias(className2 = Files.getClassName(classPath = (File)objs[0], classFile = (File)objs[1])) : !Zhiqim.setClassAlias(className = Jars.getClassName(jarEntry = (JarEntry)objs[1])));
            }
        };
        return Resources.scanClassPath(filter, handler, pathList);
    }

    private static boolean setClassAlias(String className) {
        Class<?> cls = Classes.forName(className);
        if (cls == null) {
            return true;
        }
        if (cls.isAnnotationPresent(AnGlobal.class) && cls.isAnnotationPresent(AnNew.class)) {
            log.error((Object)"[%s]\u4e0d\u80fd\u540c\u65f6\u5b9a\u4e49\u6210[FGlobal]\u548c[FNew]\u6ce8\u89e3\uff0c\u4e24\u8005\u53ea\u5141\u8bb8\u4e00\u4e2a", className);
            return false;
        }
        String alias = Annotations.getClassAlias(cls);
        if (alias == null) {
            return true;
        }
        Class<?> has = Global.getClass(alias);
        if (has != null) {
            log.error((Object)"[%s]\u548c[%s]\u7684\u7b80\u79f0[%s]\u4e0d\u5141\u8bb8\u76f8\u540c", className, has.getName(), alias);
            return false;
        }
        Global.addClass(alias, cls);
        return true;
    }
}

