/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.service.dao;

import net.redxyz.top.security.SecurityClient;
import net.redxyz.top.security.SecurityConstants;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Htmls;
import org.zhiqim.kernel.util.Validates;

public class SecurityDao
implements SecurityConstants {
    private static final Log log = LogFactory.getLog(SecurityDao.class);

    public static String decryptSimple(String data, String sessionId) {
        return SecurityDao.decrypt(data, sessionId, "simple");
    }

    public static String decryptPhone(String data, String sessionId) {
        return SecurityDao.decrypt(data, sessionId, "phone");
    }

    public static String encryptPhone(String data, String sessionId) {
        return SecurityDao.encrypt(data, sessionId, "phone");
    }

    public static String encryptSimple(String data, String sessionId) {
        return SecurityDao.encrypt(data, sessionId, "simple");
    }

    private static String decrypt(String data, String sessionId, String type) {
        if (Validates.isEmpty((String)data)) {
            log.error((Object)("sessionId[" + sessionId + "]\u89e3\u5bc6\u6570\u636e\u4e3a\u7a7a"));
            return data;
        }
        try {
            if (SecurityClient.isEncryptData(data, type)) {
                data = ((SecurityClient)Global.get(SecurityClient.class)).decrypt(data, type, sessionId);
            }
        }
        catch (Exception e) {
            log.error((Object)("sessionId[" + sessionId + "]\u89e3\u5bc6\u5931\u8d25:"), new Object[]{e.getMessage()});
        }
        return Htmls.filterAll((String)data);
    }

    private static String encrypt(String data, String sessionId, String type) {
        if (Validates.isEmpty((String)data)) {
            log.error((Object)("sessionId[" + sessionId + "]\u52a0\u5bc6\u6570\u636e\u4e3a\u7a7a"));
            return data;
        }
        try {
            if (SecurityClient.isEncryptData(data, type)) {
                return data;
            }
            data = ((SecurityClient)Global.get(SecurityClient.class)).encrypt(data, type, sessionId);
        }
        catch (Exception e) {
            log.error((Object)("sessionId[" + sessionId + "]\u52a0\u5bc6\u5931\u8d25:"), new Object[]{e.getMessage()});
        }
        return data;
    }
}

