/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.service.dao;

import java.util.HashMap;
import java.util.List;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.data.item.Item;
import net.redxyz.top.data.itemqianniu.Advise;
import net.redxyz.top.data.itemqianniu.Punish;
import net.redxyz.top.data.itemqianniu.Shield;
import net.redxyz.top.data.itemqianniu.Warn;
import net.redxyz.top.message.itemqianniu.ItemProcessAdvisesSearchRequest;
import net.redxyz.top.message.itemqianniu.ItemProcessAdvisesSearchResponse;
import net.redxyz.top.message.itemqianniu.ItemProcessPunishesSearchRequest;
import net.redxyz.top.message.itemqianniu.ItemProcessPunishesSearchResponse;
import net.redxyz.top.message.itemqianniu.ItemProcessShieldsSearchRequest;
import net.redxyz.top.message.itemqianniu.ItemProcessShieldsSearchResponse;
import net.redxyz.top.message.itemqianniu.ItemProcessWarnsSearchRequest;
import net.redxyz.top.message.itemqianniu.ItemProcessWarnsSearchResponse;
import net.redxyz.top.portal.model.AdviseModel;
import net.redxyz.top.portal.model.PunishModel;
import net.redxyz.top.portal.model.ShieldModel;
import net.redxyz.top.portal.model.WarnModel;

public class QnItemDao {
    public static ItemProcessShieldsSearchResponse getAllShield(String nick, String sessionId, List<ShieldModel> dtoList, int pageNo, int pageSize) throws Exception {
        ItemProcessShieldsSearchRequest req = new ItemProcessShieldsSearchRequest();
        req.setNick(nick);
        req.setSession(sessionId);
        req.setPageNo(pageNo);
        req.setPageSize(pageSize);
        ItemProcessShieldsSearchResponse resp = TaobaoService.invokeTaobaoService(req);
        List<Item> itemList = TaobaoService.getItemService().getBatchItems(nick, sessionId, resp.getItemIdList());
        HashMap<Long, Item> map = new HashMap<Long, Item>();
        for (Item item : itemList) {
            map.put(item.getNumIid(), item);
        }
        for (Shield shield : resp.getShieldList()) {
            ShieldModel dto = new ShieldModel();
            dto.setRuleTypesName(shield.getRuleTypesName());
            dto.setGmtModified(shield.getGmtModified());
            Item item = (Item)map.get(shield.getItemId());
            if (item != null) {
                dto.setItemId(item.getNumIid());
                dto.setPicUrl(item.getPicUrl());
                dto.setTitle(item.getTitle());
            }
            dtoList.add(dto);
        }
        return resp;
    }

    public static ItemProcessWarnsSearchResponse getAllWarn(String nick, String sessionId, List<WarnModel> dtoList, int pageNo, int pageSize) throws Exception {
        ItemProcessWarnsSearchRequest req = new ItemProcessWarnsSearchRequest();
        req.setNick(nick);
        req.setSession(sessionId);
        req.setPageNo(pageNo);
        req.setPageSize(pageSize);
        ItemProcessWarnsSearchResponse resp = TaobaoService.invokeTaobaoService(req);
        List<Item> itemList = TaobaoService.getItemService().getBatchItems(nick, sessionId, resp.getItemIdList());
        HashMap<Long, Item> map = new HashMap<Long, Item>();
        for (Item item : itemList) {
            map.put(item.getNumIid(), item);
        }
        for (Warn warn : resp.getWarnList()) {
            WarnModel dto = new WarnModel();
            dto.setRuleTypesName(warn.getRuleTypesName());
            dto.setGmtEnd(warn.getGmtModified());
            Item item = (Item)map.get(warn.getItemId());
            if (item != null) {
                dto.setItemId(item.getNumIid());
                dto.setPicUrl(item.getPicUrl());
                dto.setTitle(item.getTitle());
            }
            dtoList.add(dto);
        }
        return resp;
    }

    public static ItemProcessPunishesSearchResponse getAllPunish(String nick, String sessionId, List<PunishModel> dtoList, int pageNo, int pageSize) throws Exception {
        ItemProcessPunishesSearchRequest req = new ItemProcessPunishesSearchRequest();
        req.setNick(nick);
        req.setSession(sessionId);
        req.setPageNo(pageNo);
        req.setPageSize(pageSize);
        ItemProcessPunishesSearchResponse resp = TaobaoService.invokeTaobaoService(req);
        List<Item> itemList = TaobaoService.getItemService().getBatchItems(nick, sessionId, resp.getItemIdList());
        HashMap<Long, Item> map = new HashMap<Long, Item>();
        for (Item item : itemList) {
            map.put(item.getNumIid(), item);
        }
        for (Punish punish : resp.getPunishList()) {
            PunishModel dto = new PunishModel();
            dto.setRuleTypesName(punish.getRuleTypesName());
            dto.setGmtModified(punish.getGmtModified());
            Item item = (Item)map.get(punish.getItemId());
            if (item != null) {
                dto.setItemId(item.getNumIid());
                dto.setPicUrl(item.getPicUrl());
                dto.setTitle(item.getTitle());
            }
            dtoList.add(dto);
        }
        return resp;
    }

    public static ItemProcessAdvisesSearchResponse getAllAdvises(String nick, String sessionId, List<AdviseModel> dtoList, int pageNo, int pageSize) throws Exception {
        ItemProcessAdvisesSearchRequest req = new ItemProcessAdvisesSearchRequest();
        req.setNick(nick);
        req.setSession(sessionId);
        req.setPageNo(pageNo);
        req.setPageSize(pageSize);
        ItemProcessAdvisesSearchResponse resp = TaobaoService.invokeTaobaoService(req);
        List<Item> itemList = TaobaoService.getItemService().getBatchItems(nick, sessionId, resp.getItemIdList());
        HashMap<Long, Item> map = new HashMap<Long, Item>();
        for (Item item : itemList) {
            map.put(item.getNumIid(), item);
        }
        for (Advise advise : resp.getAdviseList()) {
            AdviseModel dto = new AdviseModel();
            dto.setRuleTypesName(advise.getRuleTypesName());
            dto.setGmtEnd(advise.getGmtEnd());
            Item item = (Item)map.get(advise.getItemId());
            if (item != null) {
                dto.setItemId(item.getNumIid());
                dto.setPicUrl(item.getPicUrl());
                dto.setTitle(item.getTitle());
            }
            dtoList.add(dto);
        }
        return resp;
    }
}

