/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.service.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.data.item.Item;
import net.redxyz.top.data.shop.SellerCat;
import net.redxyz.top.message.item.ItemSellerGetResponse4_24625;
import net.redxyz.top.message.item.ItemsInventoryGetResponse4_162;
import net.redxyz.top.message.item.ItemsOnsaleGetResponse4_18;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.dbo.Selector;

public class ItemDao {
    private static String OUTER_ID_SCOPE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-_";

    public static void addWhereQ(Selector selector, String q) {
        if (Validates.isEmpty((String)q)) {
            return;
        }
        long numIid = ItemDao.getNumIidFromQ(q);
        if (numIid != -1L) {
            selector.addMaybe("numIid", (Object)numIid);
        } else if (ItemDao.isOuterIdFromQ(q)) {
            selector.addMaybe("outerId", (Object)q);
        } else {
            selector.addMaybeLike("title", (Object)q);
        }
    }

    public static List<Item> queryItemList(List<Item> itemList, String q) {
        if (Validates.isEmpty((String)q)) {
            return itemList;
        }
        ArrayList<Item> iList = new ArrayList<Item>();
        long iid = ItemDao.getNumIidFromQ(q);
        if (iid != -1L) {
            for (Item item : itemList) {
                if (item.getNumIid() != iid) continue;
                iList.add(item);
                return iList;
            }
            return iList;
        }
        if (ItemDao.isOuterIdFromQ(q)) {
            for (Item item : itemList) {
                if (!q.equals(item.getOuterId())) continue;
                iList.add(item);
            }
            if (!iList.isEmpty()) {
                return iList;
            }
        }
        for (Item item : itemList) {
            if (item.getTitle().indexOf(q) == -1) continue;
            iList.add(item);
        }
        return iList;
    }

    public static int getItemListOnsalePage(List<Item> itemList, String nick, String sessionId, String sellerCid, String q, int page, int pageSize) throws Exception {
        List<Item> oList;
        long iid = ItemDao.getNumIidFromQ(q);
        if (iid != -1L) {
            Item item;
            ItemSellerGetResponse4_24625 resp = TaobaoService.getItemService().getItem(nick, sessionId, iid);
            if (resp.isSuccess() && (item = resp.getItem()).isOnsale() && nick.equals(item.getNick())) {
                itemList.add(item);
                return 1;
            }
            return 0;
        }
        if (ItemDao.isOuterIdFromQ(q) && !(oList = ItemDao.getItemListOuterId(nick, sessionId, q, true, false)).isEmpty()) {
            int total = 0;
            for (Item item : oList) {
                if (!item.isOnsale()) continue;
                itemList.add(item);
                ++total;
            }
            return total;
        }
        ItemsOnsaleGetResponse4_18 resp = TaobaoService.getItemService().getOnsaleItemList(nick, sessionId, page, pageSize, sellerCid, q);
        itemList.addAll(resp.getItemList());
        return resp.getTotalResults();
    }

    public static int getItemListInventoryPage(List<Item> itemList, String nick, String sessionId, String sellerCid, String banner, String q, int page, int pageSize) throws Exception {
        List<Item> oList;
        long iid = ItemDao.getNumIidFromQ(q);
        if (iid != -1L) {
            Item item;
            ItemSellerGetResponse4_24625 resp = TaobaoService.getItemService().getItem(nick, sessionId, iid);
            if (resp.isSuccess() && (item = resp.getItem()).isInstock() && nick.equals(item.getNick())) {
                itemList.add(item);
                return 1;
            }
            return 0;
        }
        if (ItemDao.isOuterIdFromQ(q) && !(oList = ItemDao.getItemListOuterId(nick, sessionId, q, true, false)).isEmpty()) {
            int total = 0;
            for (Item item : oList) {
                if (!item.isInstock()) continue;
                itemList.add(item);
                ++total;
            }
            return total;
        }
        ItemsInventoryGetResponse4_162 resp = TaobaoService.getItemService().getInventoryItemList(nick, sessionId, page, pageSize, sellerCid, banner, q);
        itemList.addAll(resp.getItemList());
        return resp.getTotalResults();
    }

    public static int getItemListShowPage(List<Item> itemList, String nick, String sessionId, String sellerCid, String q, int page, int pageSize) throws Exception {
        List<Item> oList;
        long iid = ItemDao.getNumIidFromQ(q);
        if (iid != -1L) {
            Item item;
            ItemSellerGetResponse4_24625 resp = TaobaoService.getItemService().getItem(nick, sessionId, iid);
            if (resp.isSuccess() && (item = resp.getItem()).isShowcase() && nick.equals(item.getNick())) {
                itemList.add(item);
                return 1;
            }
            return 0;
        }
        if (ItemDao.isOuterIdFromQ(q) && !(oList = ItemDao.getItemListOuterId(nick, sessionId, q, true, false)).isEmpty()) {
            int total = 0;
            for (Item item : oList) {
                if (!item.isShowcase()) continue;
                itemList.add(item);
                ++total;
            }
            return total;
        }
        ItemsOnsaleGetResponse4_18 resp = TaobaoService.getItemService().getShowcaseItemList(nick, sessionId, page, pageSize, sellerCid, q);
        itemList.addAll(resp.getItemList());
        return resp.getTotalResults();
    }

    public static List<Item> getItemListAll(String nick, String sessionId, String sellerCid, String q, boolean isOnsale, boolean isInventory) throws Exception {
        if (isOnsale && isInventory) {
            List<Object> itemList;
            long iid = ItemDao.getNumIidFromQ(q);
            if (iid != -1L) {
                Item item;
                ArrayList<Item> itemList2 = new ArrayList<Item>();
                ItemSellerGetResponse4_24625 resp = TaobaoService.getItemService().getItem(nick, sessionId, iid);
                if (resp.isSuccess() && nick.equals((item = resp.getItem()).getNick())) {
                    itemList2.add(item);
                }
                return itemList2;
            }
            if (ItemDao.isOuterIdFromQ(q) && !(itemList = ItemDao.getItemListOuterId(nick, sessionId, q, isOnsale, isInventory)).isEmpty()) {
                return itemList;
            }
            itemList = new ArrayList();
            ArrayList<Item> oList = TaobaoService.getItemService().getOnsaleItemListAll(nick, sessionId, sellerCid, q);
            ArrayList<Item> iList = TaobaoService.getItemService().getInventoryItemListAll(nick, sessionId, sellerCid, q);
            itemList.addAll(oList);
            itemList.addAll(iList);
            return itemList;
        }
        ArrayList<Item> itemList = new ArrayList<Item>();
        if (isOnsale) {
            itemList.addAll(ItemDao.getItemListAllOnsale(nick, sessionId, sellerCid, q));
        }
        if (isInventory) {
            itemList.addAll(ItemDao.getItemListAllInventory(nick, sessionId, sellerCid, q));
        }
        return itemList;
    }

    public static PageResult<Item> getItemPage(String nick, String sessionId, String sellerCid, String q, boolean isOnsale, boolean isInventory, List<Long> filterIidList, int pageNo, int pageSize) throws Exception {
        if (isOnsale && isInventory) {
            List<Object> itemList;
            long iid = ItemDao.getNumIidFromQ(q);
            if (iid != -1L) {
                Item item;
                ArrayList<Item> itemList2 = new ArrayList<Item>();
                ItemSellerGetResponse4_24625 resp = TaobaoService.getItemService().getItem(nick, sessionId, iid);
                if (resp.isSuccess() && nick.equals((item = resp.getItem()).getNick()) && !filterIidList.contains(item.getNumIid())) {
                    itemList2.add(item);
                }
                return PageBuilder.pageResult((int)pageNo, (int)pageSize, itemList2);
            }
            if (ItemDao.isOuterIdFromQ(q) && !(itemList = ItemDao.getItemListOuterId(nick, sessionId, q, isOnsale, isInventory)).isEmpty()) {
                Iterator<Object> it = itemList.iterator();
                while (it.hasNext()) {
                    Item item = (Item)it.next();
                    if (!filterIidList.contains(item.getNumIid())) continue;
                    it.remove();
                }
                return PageBuilder.pageResult((int)pageNo, (int)pageSize, itemList);
            }
            itemList = new ArrayList<Item>();
            itemList.addAll(TaobaoService.getItemService().getOnsaleItemListAll(nick, sessionId, sellerCid, q));
            itemList.addAll(TaobaoService.getItemService().getInventoryItemListAll(nick, sessionId, sellerCid, "", q));
            Iterator<Object> it = itemList.iterator();
            while (it.hasNext()) {
                Item item = (Item)it.next();
                if (!filterIidList.contains(item.getNumIid())) continue;
                it.remove();
            }
            return PageBuilder.pageResult((int)pageNo, (int)pageSize, itemList);
        }
        if (isOnsale) {
            return ItemDao.getItemPageOnsale(nick, sessionId, sellerCid, q, filterIidList, pageNo, pageSize);
        }
        if (isInventory) {
            return ItemDao.getItemPageInventory(nick, sessionId, sellerCid, q, filterIidList, pageNo, pageSize);
        }
        throw new Exception("\u8bf7\u9009\u62e9\u51fa\u552e\u4e2d\u6216\u4ed3\u5e93\u4e2d\u9009\u9879");
    }

    public static List<Item> getItemListAllOnsale(String nick, String sessionId, String sellerCid, String q) throws Exception {
        List<Item> itemList;
        long iid = ItemDao.getNumIidFromQ(q);
        if (iid != -1L) {
            Item item;
            ArrayList<Item> itemList2 = new ArrayList<Item>();
            ItemSellerGetResponse4_24625 resp = TaobaoService.getItemService().getItem(nick, sessionId, iid);
            if (resp.isSuccess() && (item = resp.getItem()).isOnsale() && nick.equals(item.getNick())) {
                itemList2.add(item);
            }
            return itemList2;
        }
        if (ItemDao.isOuterIdFromQ(q) && !(itemList = ItemDao.getItemListOuterId(nick, sessionId, q, true, false)).isEmpty()) {
            return itemList;
        }
        return TaobaoService.getItemService().getOnsaleItemListAll(nick, sessionId, sellerCid, q);
    }

    public static PageResult<Item> getItemPageOnsale(String nick, String sessionId, String sellerCid, String q, List<Long> filterIidList, int pageNo, int pageSize) throws Exception {
        List<Item> itemList;
        long iid = ItemDao.getNumIidFromQ(q);
        if (iid != -1L) {
            Item item;
            ArrayList<Item> itemList2 = new ArrayList<Item>();
            ItemSellerGetResponse4_24625 resp = TaobaoService.getItemService().getItem(nick, sessionId, iid);
            if (resp.isSuccess() && (item = resp.getItem()).isOnsale() && nick.equals(item.getNick()) && !filterIidList.contains(item.getNumIid())) {
                itemList2.add(item);
            }
            return PageBuilder.pageResult((int)pageNo, (int)pageSize, itemList2);
        }
        if (ItemDao.isOuterIdFromQ(q) && !(itemList = ItemDao.getItemListOuterId(nick, sessionId, q, true, false)).isEmpty()) {
            Iterator<Item> it = itemList.iterator();
            while (it.hasNext()) {
                Item item = it.next();
                if (!filterIidList.contains(item.getNumIid())) continue;
                it.remove();
            }
            return PageBuilder.pageResult((int)pageNo, (int)pageSize, itemList);
        }
        itemList = TaobaoService.getItemService().getOnsaleItemListAll(nick, sessionId, sellerCid, q);
        Iterator<Item> it = itemList.iterator();
        while (it.hasNext()) {
            Item item = it.next();
            if (!filterIidList.contains(item.getNumIid())) continue;
            it.remove();
        }
        return PageBuilder.pageResult((int)pageNo, (int)pageSize, itemList);
    }

    private static List<Item> getItemListAllInventory(String nick, String sessionId, String sellerCid, String q) throws Exception {
        List<Item> itemList;
        long iid = ItemDao.getNumIidFromQ(q);
        if (iid != -1L) {
            Item item;
            ArrayList<Item> itemList2 = new ArrayList<Item>();
            ItemSellerGetResponse4_24625 resp = TaobaoService.getItemService().getItem(nick, sessionId, iid);
            if (resp.isSuccess() && (item = resp.getItem()).isInstock() && nick.equals(item.getNick())) {
                itemList2.add(item);
            }
            return itemList2;
        }
        if (ItemDao.isOuterIdFromQ(q) && !(itemList = ItemDao.getItemListOuterId(nick, sessionId, q, false, true)).isEmpty()) {
            return itemList;
        }
        return TaobaoService.getItemService().getInventoryItemListAll(nick, sessionId, sellerCid, q);
    }

    private static PageResult<Item> getItemPageInventory(String nick, String sessionId, String sellerCid, String q, List<Long> filterIidList, int pageNo, int pageSize) throws Exception {
        List<Item> itemList;
        long iid = ItemDao.getNumIidFromQ(q);
        if (iid != -1L) {
            Item item;
            ArrayList<Item> itemList2 = new ArrayList<Item>();
            ItemSellerGetResponse4_24625 resp = TaobaoService.getItemService().getItem(nick, sessionId, iid);
            if (resp.isSuccess() && (item = resp.getItem()).isInstock() && nick.equals(item.getNick()) && !filterIidList.contains(item.getNumIid())) {
                itemList2.add(item);
            }
            return PageBuilder.pageResult((int)pageNo, (int)pageSize, itemList2);
        }
        if (ItemDao.isOuterIdFromQ(q) && !(itemList = ItemDao.getItemListOuterId(nick, sessionId, q, false, true)).isEmpty()) {
            Iterator<Item> it = itemList.iterator();
            while (it.hasNext()) {
                Item item = it.next();
                if (!filterIidList.contains(item.getNumIid())) continue;
                it.remove();
            }
            return PageBuilder.pageResult((int)pageNo, (int)pageSize, itemList);
        }
        itemList = TaobaoService.getItemService().getInventoryItemListAll(nick, sessionId, sellerCid, "", q);
        Iterator<Item> it = itemList.iterator();
        while (it.hasNext()) {
            Item item = it.next();
            if (!filterIidList.contains(item.getNumIid())) continue;
            it.remove();
        }
        return PageBuilder.pageResult((int)pageNo, (int)pageSize, itemList);
    }

    private static List<Item> getItemListOuterId(String nick, String sessionId, String outerId, boolean isOnsale, boolean isInventory) throws Exception {
        ArrayList<Item> itemList = TaobaoService.getItemService().getItemsByOuterId(nick, sessionId, outerId);
        if (itemList.isEmpty() || isOnsale && isInventory) {
            return itemList;
        }
        ArrayList<Item> iList = new ArrayList<Item>();
        for (Item item : itemList) {
            if (isOnsale && item.isOnsale()) {
                iList.add(item);
            }
            if (!isInventory || !item.isInstock()) continue;
            iList.add(item);
        }
        return iList;
    }

    public static long getNumIidFromQ(String q) {
        String id;
        long numIid = -1L;
        if (Validates.isNumericLen((String)q, (int)10, (int)20)) {
            numIid = Long.parseLong(q);
        } else if ((Strings.startsWithIgnoreCase((String)q, (String)"http://") || Strings.startsWithIgnoreCase((String)q, (String)"https://")) && Validates.isNumericLen((String)(id = Urls.get((String)q, (String)"id")), (int)10, (int)20)) {
            numIid = Long.parseLong(id);
        }
        return numIid;
    }

    public static boolean isOuterIdFromQ(String q) {
        return Validates.isScope((String)q, (String)OUTER_ID_SCOPE);
    }

    public static List<SellerCat> getSellercatsList(String nick, String sessionId) throws Exception {
        ArrayList<SellerCat> sellerCats = TaobaoService.getShopService().getSellercatsList(nick, sessionId);
        HashMap map = new HashMap();
        for (SellerCat sellerCat : sellerCats) {
            ArrayList<Integer> subCids = new ArrayList<Integer>();
            subCids.add(sellerCat.getCid());
            map.put(sellerCat.getCid(), subCids);
        }
        for (SellerCat sellerCat : sellerCats) {
            if (sellerCat.getParentCid() == 0) continue;
            ((List)map.get(sellerCat.getParentCid())).add(sellerCat.getCid());
        }
        for (SellerCat sellerCat : sellerCats) {
            int cid = sellerCat.getCid();
            List cidList = (List)map.get(cid);
            String cids = Lists.toString((List)cidList, (String)",");
            sellerCat.setCids(cids);
        }
        return sellerCats;
    }
}

