/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.service;

import java.util.List;
import net.redxyz.top.TaobaoException;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.data.picture.Picture;
import net.redxyz.top.data.picture.PictureCategory;
import net.redxyz.top.message.picture.PictureCatecoryAddRequest;
import net.redxyz.top.message.picture.PictureCatecoryAddResponse;
import net.redxyz.top.message.picture.PictureCatecoryGetRequest;
import net.redxyz.top.message.picture.PictureCatecoryGetResponse;
import net.redxyz.top.message.picture.PictureCatecoryUpdateRequest;
import net.redxyz.top.message.picture.PictureCatecoryUpdateResponse;
import net.redxyz.top.message.picture.PictureDeleteRequest;
import net.redxyz.top.message.picture.PictureDeleteResponse;
import net.redxyz.top.message.picture.PictureGetRequest;
import net.redxyz.top.message.picture.PictureGetResponse;
import net.redxyz.top.message.picture.PictureIsreferencedGetRequest;
import net.redxyz.top.message.picture.PictureIsreferencedGetResponse;
import net.redxyz.top.message.picture.PicturePicturesCountRequest;
import net.redxyz.top.message.picture.PicturePicturesCountResponse;
import net.redxyz.top.message.picture.PicturePicturesGetRequest;
import net.redxyz.top.message.picture.PicturePicturesGetResponse;
import net.redxyz.top.message.picture.PictureReplaceRequest;
import net.redxyz.top.message.picture.PictureReplaceResponse;
import net.redxyz.top.message.picture.PictureUploadRequest;
import net.redxyz.top.message.picture.PictureUploadResponse;

public class TaobaoPictureService {
    public List<PictureCategory> getPictureCatecoryList(String nick, String sessionId, String type, long parentId, long pictureCategoryId, String pictureCategoryName) throws Exception {
        PictureCatecoryGetRequest req = new PictureCatecoryGetRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setType(type);
        req.setPictureCategoryName(pictureCategoryName);
        req.setPictureCategoryId(pictureCategoryId);
        req.setParentId(parentId);
        PictureCatecoryGetResponse resp = TaobaoService.invokeTaobaoService(req);
        if (!resp.isSuccess()) {
            throw new Exception("\u67e5\u8be2\u5356\u5bb6\u81ea\u5b9a\u4e49\u56fe\u7247\u5206\u7c7b\u5217\u8868\u65f6\u5f02\u5e38:" + resp);
        }
        return resp.getPictureCategoryList();
    }

    public List<PictureCategory> getPictureCatecoryList(String nick, String sessionId) throws Exception {
        PictureCatecoryGetRequest req = new PictureCatecoryGetRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setType("user-define");
        PictureCatecoryGetResponse resp = TaobaoService.invokeTaobaoService(req);
        if (!resp.isSuccess()) {
            throw new Exception("\u67e5\u8be2\u5356\u5bb6\u81ea\u5b9a\u4e49\u56fe\u7247\u5206\u7c7b\u5217\u8868\u65f6\u5f02\u5e38:" + resp);
        }
        return resp.getPictureCategoryList();
    }

    public PictureCatecoryAddResponse addPictureCatecory(String nick, String sessionId, long parentId, String pictureCategoryName) {
        PictureCatecoryAddRequest req = new PictureCatecoryAddRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setPictureCategoryName(pictureCategoryName);
        req.setParentId(parentId);
        return TaobaoService.invokeTaobaoService(req);
    }

    public PictureCatecoryUpdateResponse updatePictureCatecory(String nick, String sessionId, long categoryId, long parentId, String categoryName) {
        PictureCatecoryUpdateRequest req = new PictureCatecoryUpdateRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setCategoryId(categoryId);
        req.setCategoryName(categoryName);
        req.setParentId(parentId);
        return TaobaoService.invokeTaobaoService(req);
    }

    public List<PictureCategory> getPictureCatecory(String nick, String sessionId, long parentId, long pictureCategoryId, String pictureCategoryName, String type) throws Exception {
        PictureCatecoryGetRequest req = new PictureCatecoryGetRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setParentId(parentId);
        req.setType(type);
        if (pictureCategoryId != -1L) {
            req.setPictureCategoryId(pictureCategoryId);
        }
        req.setPictureCategoryName(pictureCategoryName);
        PictureCatecoryGetResponse resp = TaobaoService.invokeTaobaoService(req);
        if (!resp.isSuccess()) {
            throw new Exception("\u83b7\u53d6\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff1a" + resp);
        }
        return resp.getPictureCategoryList();
    }

    public PictureIsreferencedGetResponse isReferencedPicture(String nick, String sessionId, int pictureId) {
        PictureIsreferencedGetRequest req = new PictureIsreferencedGetRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setPictureId(pictureId);
        return TaobaoService.invokeTaobaoService(req);
    }

    public Picture getPicture(String nick, String sessionId, long pictureId) throws Exception {
        PictureGetRequest req = new PictureGetRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setPictureId(pictureId);
        PictureGetResponse resp = TaobaoService.invokeTaobaoService(req);
        if (!resp.isSuccess()) {
            throw new Exception("\u83b7\u53d6\u56fe\u7247\u4fe1\u606f\u5931\u8d25\uff0c" + resp);
        }
        return resp.getPictureList().get(0);
    }

    @Deprecated
    public PictureGetResponse getPictureList(String nick, String sessionId, long pictureCategoryId, String title, String orderBy, String clientType, int pageNo, int pageSize) {
        PictureGetRequest req = new PictureGetRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setPictureCategoryId(pictureCategoryId);
        req.setTitle(title);
        req.setOrderBy(orderBy);
        req.setClientType(clientType);
        req.setPageNo(pageNo);
        req.setPageSize(pageSize);
        return TaobaoService.invokeTaobaoService(req);
    }

    public PicturePicturesGetResponse getPictures(String nick, String sessionId, long pictureCategoryId, String title, String orderBy, String clientType, int currentPage, int pageSize) {
        PicturePicturesGetRequest req = new PicturePicturesGetRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setPictureCategoryId(pictureCategoryId);
        req.setTitle(title);
        req.setClientType(clientType);
        req.setOrderBy(orderBy);
        req.setCurrentPage(currentPage);
        req.setPageSize(pageSize);
        return TaobaoService.invokeTaobaoService(req);
    }

    public int countPictures(String nick, String sessionId, long pictureCategoryId, String title, String clientType) throws Exception {
        PicturePicturesCountRequest req = new PicturePicturesCountRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setPictureCategoryId(pictureCategoryId);
        req.setTitle(title);
        req.setClientType(clientType);
        PicturePicturesCountResponse resp = TaobaoService.invokeTaobaoService(req);
        if (!resp.isSuccess()) {
            throw new TaobaoException(resp.getError(), "\u67e5\u8be2\u56fe\u7247\u603b\u6570\u65f6\u5f02\u5e38:" + resp.getErrorMsg());
        }
        return resp.getTotals();
    }

    public boolean deletePicture(String nick, String sessionId, String pictureIds) throws TaobaoException {
        PictureDeleteRequest req = new PictureDeleteRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setPictureIds(pictureIds);
        PictureDeleteResponse resp = TaobaoService.invokeTaobaoService(req);
        if (resp.isTaobaoFail()) {
            resp = TaobaoService.invokeTaobaoService(req);
        }
        if (resp.isGetFail()) {
            return true;
        }
        if ("isv.pictureServiceClient-service-errorPICTURE_QUERY_PICTURE_FAILED".equals(resp.getSubCode())) {
            return true;
        }
        if (!resp.isSuccess()) {
            throw new TaobaoException(resp.getError(), "\u5220\u9664\u56fe\u7247\u5931\u8d25\uff0c" + resp);
        }
        return resp.isSuccess();
    }

    public PictureUploadResponse uploadPicture(String nick, String sessionId, long pictureCategoryId, String imageInputTitle, String title, byte[] img, int type) throws Exception {
        PictureUploadResponse resp;
        PictureUploadRequest req = new PictureUploadRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setPictureCategoryId(pictureCategoryId);
        req.setTitle(title);
        req.setImg(img);
        req.setImageInputTitle(imageInputTitle);
        if (type == 1) {
            req.setClientType("client:phone");
        }
        if ((resp = TaobaoService.invokeTaobaoService(req)).isTaobaoFail()) {
            resp = TaobaoService.invokeTaobaoService(req);
        }
        return resp;
    }

    public PictureReplaceResponse replacePicture(String nick, String sessionId, long pictureId, String suffix, byte[] data) throws Exception {
        PictureReplaceRequest req = new PictureReplaceRequest();
        req.setNick(nick);
        req.setSession(sessionId);
        req.setPictureId(pictureId);
        req.setImageData(data);
        req.setSuffix(suffix);
        return TaobaoService.invokeTaobaoService(req);
    }

    public long getRootCatgoryId(String nick, String sessionId, long parentId, String catgoryName) throws Exception {
        List<PictureCategory> pictureCategoryList = this.getPictureCatecory(nick, sessionId, parentId, -1L, catgoryName, null);
        if (pictureCategoryList.size() > 0) {
            return pictureCategoryList.get(0).getPictureCategoryId();
        }
        PictureCatecoryAddResponse resp = this.addPictureCatecory(nick, sessionId, parentId, catgoryName);
        if (!resp.isSuccess()) {
            throw new TaobaoException(resp.getError(), "\u83b7\u53d6\u5206\u7c7bID\u65f6\u5f02\u5e38:" + resp.getErrorMsg());
        }
        return resp.getPictureCategoryId();
    }
}

