/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.portal.actionpc.item;

import java.util.ArrayList;
import java.util.List;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.data.item.Item;
import net.redxyz.top.data.shop.SellerCat;
import net.redxyz.top.portal.SessionUser;
import net.redxyz.top.service.Constants;
import net.redxyz.top.service.dao.ItemDao;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Validates;

public class PcItemManageAction
implements Action,
Constants {
    public void execute(HttpRequest request) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String itemStatus = request.getParameter("itemStatus", "onsale");
        String nick = sessionUser.getNick();
        List<SellerCat> sellerCats = ItemDao.getSellercatsList(nick, sessionId);
        request.setAttribute("sellerCats", sellerCats);
        String flag = request.getParameter("flag");
        if (Validates.isNotEmpty((String)flag)) {
            itemStatus = flag;
        }
        request.setAttribute("itemStatus", (Object)itemStatus);
    }

    @AnIntercept(value={"chkAjax"})
    public static String itemChoose(HttpRequest request, String numIids) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        List numIidArray = Lists.toLongList((String)numIids, (String)",");
        List<Item> itemList = TaobaoService.getItemService().getBatchItems(nick, sessionId, numIidArray);
        return Jsons.toString(itemList);
    }

    @AnIntercept(value={"chkAjax"})
    public static String queryAllNum(HttpRequest request) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ArrayList<Item> itemList = new ArrayList<Item>();
        int totalOnsale = ItemDao.getItemListOnsalePage(itemList, nick, sessionId, "", "", 1, 1);
        int totalInventory = ItemDao.getItemListInventoryPage(itemList, nick, sessionId, "", "", "", 1, 1);
        int totalSoldOut = ItemDao.getItemListInventoryPage(itemList, nick, sessionId, "", "sold_out", "", 1, 1);
        return "{\"totalOnsale\":" + totalOnsale + ",\"totalInventory\":" + totalInventory + ",\"totalSoldOut\":" + totalSoldOut + "}";
    }

    @AnIntercept(value={"chkAjax"})
    public static void queryOnsale(HttpRequest request, String sellerCid, String q, int page) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ArrayList<Item> itemList = new ArrayList<Item>();
        int total = ItemDao.getItemListOnsalePage(itemList, nick, sessionId, sellerCid, q, page, 10);
        PageResult result = PageBuilder.newResult((int)total, (int)page, (int)10, itemList);
        HashMapSO attrMap = new HashMapSO();
        attrMap.put("result", (Object)result);
        String ret = ZmlContexts.parseZmlPath((HttpRequest)request, (String)"/zview/pc/item/presenter/pcItemOnsale.zml", (MapSO)attrMap);
        request.setResponseResult(ret);
    }

    @AnIntercept(value={"chkAjax"})
    public static void queryInventory(HttpRequest request, String sellerCid, String q, int page) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ArrayList<Item> itemList = new ArrayList<Item>();
        int total = ItemDao.getItemListInventoryPage(itemList, nick, sessionId, sellerCid, "", q, page, 10);
        PageResult result = PageBuilder.newResult((int)total, (int)page, (int)10, itemList);
        HashMapSO attrMap = new HashMapSO();
        attrMap.put("result", (Object)result);
        String ret = ZmlContexts.parseZmlPath((HttpRequest)request, (String)"/zview/pc/item/presenter/pcItemInventory.zml", (MapSO)attrMap);
        request.setResponseResult(ret);
    }

    @AnIntercept(value={"chkAjax"})
    public static void queryShowcase(HttpRequest request, String sellerCid, String q, int page) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ArrayList<Item> itemList = new ArrayList<Item>();
        int total = ItemDao.getItemListShowPage(itemList, nick, sessionId, sellerCid, q, page, 10);
        PageResult result = PageBuilder.newResult((int)total, (int)page, (int)10, itemList);
        String ret = ZmlContexts.parseZmlPath((HttpRequest)request, (String)"/zview/pc/item/presenter/pcItemShowcase.zml", (String)"result", (Object)result);
        request.setResponseResult(ret);
    }

    @AnIntercept(value={"chkAjax"})
    public static void querySoldOut(HttpRequest request, String sellerCid, String q, int page) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ArrayList<Item> itemList = new ArrayList<Item>();
        int total = ItemDao.getItemListInventoryPage(itemList, nick, sessionId, sellerCid, "sold_out", q, page, 10);
        PageResult result = PageBuilder.newResult((int)total, (int)page, (int)10, itemList);
        String ret = ZmlContexts.parseZmlPath((HttpRequest)request, (String)"/zview/pc/item/presenter/pcItemSoldOut.zml", (String)"result", (Object)result);
        request.setResponseResult(ret);
    }
}

